/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding3.material;

import com.google.android.material.tabs.TabLayout;
import com.jakewharton.rxbinding3.internal.Preconditions;
import com.jakewharton.rxbinding3.material.TabLayoutSelectionEvent;
import com.jakewharton.rxbinding3.material.TabLayoutSelectionReselectedEvent;
import com.jakewharton.rxbinding3.material.TabLayoutSelectionSelectedEvent;
import com.jakewharton.rxbinding3.material.TabLayoutSelectionUnselectedEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u000bH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionEventObservable;", "Lio/reactivex/Observable;", "Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionEvent;", "view", "Lcom/google/android/material/tabs/TabLayout;", "(Lcom/google/android/material/tabs/TabLayout;)V", "getView", "()Lcom/google/android/material/tabs/TabLayout;", "subscribeActual", "", "observer", "Lio/reactivex/Observer;", "Listener", "rxbinding-material_release"})
final class TabLayoutSelectionEventObservable
extends Observable<TabLayoutSelectionEvent> {
    @NotNull
    private final TabLayout view;

    protected void subscribeActual(@NotNull Observer<? super TabLayoutSelectionEvent> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)listener);
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            TabLayout.Tab tab = this.view.getTabAt(index);
            if (tab == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)tab, (String)"view.getTabAt(index)!!");
            observer.onNext((Object)new TabLayoutSelectionSelectedEvent(this.view, tab));
        }
    }

    @NotNull
    public final TabLayout getView() {
        return this.view;
    }

    public TabLayoutSelectionEventObservable(@NotNull TabLayout view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionEventObservable$Listener;", "Lio/reactivex/android/MainThreadDisposable;", "Lcom/google/android/material/tabs/TabLayout$OnTabSelectedListener;", "view", "Lcom/google/android/material/tabs/TabLayout;", "observer", "Lio/reactivex/Observer;", "Lcom/jakewharton/rxbinding3/material/TabLayoutSelectionEvent;", "(Lcom/google/android/material/tabs/TabLayout;Lio/reactivex/Observer;)V", "onDispose", "", "onTabReselected", "tab", "Lcom/google/android/material/tabs/TabLayout$Tab;", "onTabSelected", "onTabUnselected", "rxbinding-material_release"})
    private static final class Listener
    extends MainThreadDisposable
    implements TabLayout.OnTabSelectedListener {
        private final TabLayout view;
        private final Observer<? super TabLayoutSelectionEvent> observer;

        public void onTabSelected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new TabLayoutSelectionSelectedEvent(this.view, tab));
            }
        }

        public void onTabUnselected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new TabLayoutSelectionUnselectedEvent(this.view, tab));
            }
        }

        public void onTabReselected(@NotNull TabLayout.Tab tab) {
            Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new TabLayoutSelectionReselectedEvent(this.view, tab));
            }
        }

        protected void onDispose() {
            this.view.removeOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
        }

        public Listener(@NotNull TabLayout view, @NotNull Observer<? super TabLayoutSelectionEvent> observer) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.view = view;
            this.observer = observer;
        }
    }
}

