/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.widget.RadioGroup;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.RadioGroupCheckedChangeObservable;
import io.reactivex.functions.Consumer;

public final class RxRadioGroup {
    @CheckResult
    @NonNull
    public static InitialValueObservable<Integer> checkedChanges(@NonNull RadioGroup view) {
        Preconditions.checkNotNull(view, "view == null");
        return new RadioGroupCheckedChangeObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> checked(@NonNull RadioGroup view) {
        Preconditions.checkNotNull(view, "view == null");
        return value -> {
            if (value == -1) {
                view.clearCheck();
            } else {
                view.check(value.intValue());
            }
        };
    }

    private RxRadioGroup() {
        throw new AssertionError((Object)"No instances.");
    }
}

