/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.SeekBar;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.SeekBarChangeEvent;
import com.jakewharton.rxbinding2.widget.SeekBarProgressChangeEvent;
import com.jakewharton.rxbinding2.widget.SeekBarStartChangeEvent;
import com.jakewharton.rxbinding2.widget.SeekBarStopChangeEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class SeekBarChangeEventObservable
extends InitialValueObservable<SeekBarChangeEvent> {
    private final SeekBar view;

    SeekBarChangeEventObservable(SeekBar view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super SeekBarChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected SeekBarChangeEvent getInitialValue() {
        return SeekBarProgressChangeEvent.create(this.view, this.view.getProgress(), false);
    }

    static final class Listener
    extends MainThreadDisposable
    implements SeekBar.OnSeekBarChangeListener {
        private final SeekBar view;
        private final Observer<? super SeekBarChangeEvent> observer;

        Listener(SeekBar view, Observer<? super SeekBarChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SeekBarProgressChangeEvent.create(seekBar, progress, fromUser));
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SeekBarStartChangeEvent.create(seekBar));
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)SeekBarStopChangeEvent.create(seekBar));
            }
        }

        protected void onDispose() {
            this.view.setOnSeekBarChangeListener(null);
        }
    }
}

