/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.widget.TextSwitcher;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.functions.Consumer;

public final class RxTextSwitcher {
    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> text(final @NonNull TextSwitcher view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<CharSequence>(){

            public void accept(CharSequence text) {
                view.setText(text);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> currentText(final @NonNull TextSwitcher view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<CharSequence>(){

            public void accept(CharSequence textRes) {
                view.setCurrentText(textRes);
            }
        };
    }

    private RxTextSwitcher() {
        throw new AssertionError((Object)"No instances.");
    }
}

