/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.RatingBar;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.RatingBarChangeEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RatingBarRatingChangeEventObservable
extends InitialValueObservable<RatingBarChangeEvent> {
    private final RatingBar view;

    RatingBarRatingChangeEventObservable(RatingBar view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super RatingBarChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnRatingBarChangeListener((RatingBar.OnRatingBarChangeListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected RatingBarChangeEvent getInitialValue() {
        return RatingBarChangeEvent.create(this.view, this.view.getRating(), false);
    }

    static final class Listener
    extends MainThreadDisposable
    implements RatingBar.OnRatingBarChangeListener {
        private final RatingBar view;
        private final Observer<? super RatingBarChangeEvent> observer;

        Listener(RatingBar view, Observer<? super RatingBarChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onRatingChanged(RatingBar ratingBar, float rating, boolean fromUser) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)RatingBarChangeEvent.create(ratingBar, rating, fromUser));
            }
        }

        protected void onDispose() {
            this.view.setOnRatingBarChangeListener(null);
        }
    }
}

