/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.KeyEvent;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class ViewKeyObservable
extends Observable<KeyEvent> {
    private final View view;
    private final Predicate<? super KeyEvent> handled;

    ViewKeyObservable(View view, Predicate<? super KeyEvent> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super KeyEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnKeyListener((View.OnKeyListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnKeyListener {
        private final View view;
        private final Predicate<? super KeyEvent> handled;
        private final Observer<? super KeyEvent> observer;

        Listener(View view, Predicate<? super KeyEvent> handled, Observer<? super KeyEvent> observer) {
            this.view = view;
            this.handled = handled;
            this.observer = observer;
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.test((Object)event)) {
                        this.observer.onNext((Object)event);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnKeyListener(null);
        }
    }
}

