/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.widget.ProgressBar;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.functions.Consumer;

public final class RxProgressBar {
    @CheckResult
    @NonNull
    public static Consumer<? super Integer> incrementProgressBy(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.incrementProgressBy(value.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> incrementSecondaryProgressBy(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.incrementSecondaryProgressBy(value.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Boolean> indeterminate(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Boolean>(){

            public void accept(Boolean value) {
                view.setIndeterminate(value.booleanValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> max(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.setMax(value.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> progress(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.setProgress(value.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> secondaryProgress(final @NonNull ProgressBar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer value) {
                view.setSecondaryProgress(value.intValue());
            }
        };
    }

    private RxProgressBar() {
        throw new AssertionError((Object)"No instances.");
    }
}

