/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.v4.widget.SwipeRefreshLayout;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v4.widget.SwipeRefreshLayoutRefreshObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

public final class RxSwipeRefreshLayout {
    @CheckResult
    @NonNull
    public static Observable<Object> refreshes(@NonNull SwipeRefreshLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new SwipeRefreshLayoutRefreshObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Boolean> refreshing(final @NonNull SwipeRefreshLayout view) {
        Preconditions.checkNotNull((Object)view, (String)"view == null");
        return new Consumer<Boolean>(){

            public void accept(Boolean value) {
                view.setRefreshing(value.booleanValue());
            }
        };
    }

    private RxSwipeRefreshLayout() {
        throw new AssertionError((Object)"No instances.");
    }
}

