/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v4.widget;

import android.support.v4.widget.DrawerLayout;
import android.view.View;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class DrawerLayoutDrawerOpenedObservable
extends InitialValueObservable<Boolean> {
    private final DrawerLayout view;
    private final int gravity;

    DrawerLayoutDrawerOpenedObservable(DrawerLayout view, int gravity) {
        this.view = view;
        this.gravity = gravity;
    }

    protected void subscribeListener(Observer<? super Boolean> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.gravity, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addDrawerListener((DrawerLayout.DrawerListener)listener);
    }

    protected Boolean getInitialValue() {
        return this.view.isDrawerOpen(this.gravity);
    }

    static final class Listener
    extends MainThreadDisposable
    implements DrawerLayout.DrawerListener {
        private final DrawerLayout view;
        private final int gravity;
        private final Observer<? super Boolean> observer;

        Listener(DrawerLayout view, int gravity, Observer<? super Boolean> observer) {
            this.view = view;
            this.gravity = gravity;
            this.observer = observer;
        }

        public void onDrawerSlide(View drawerView, float slideOffset) {
        }

        public void onDrawerOpened(View drawerView) {
            int drawerGravity;
            if (!this.isDisposed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == this.gravity) {
                this.observer.onNext((Object)true);
            }
        }

        public void onDrawerClosed(View drawerView) {
            int drawerGravity;
            if (!this.isDisposed() && (drawerGravity = ((DrawerLayout.LayoutParams)drawerView.getLayoutParams()).gravity) == this.gravity) {
                this.observer.onNext((Object)false);
            }
        }

        public void onDrawerStateChanged(int newState) {
        }

        protected void onDispose() {
            this.view.removeDrawerListener((DrawerLayout.DrawerListener)this);
        }
    }
}

