/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.RecyclerView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v7.widget.RecyclerViewFlingEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RecyclerViewFlingObservable
extends Observable<RecyclerViewFlingEvent> {
    private final RecyclerView view;

    RecyclerViewFlingObservable(RecyclerView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super RecyclerViewFlingEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnFlingListener(listener.flingListener);
    }

    static final class Listener
    extends MainThreadDisposable {
        private final RecyclerView recyclerView;
        final RecyclerView.OnFlingListener flingListener;

        Listener(final RecyclerView recyclerView, final Observer<? super RecyclerViewFlingEvent> observer) {
            this.recyclerView = recyclerView;
            this.flingListener = new RecyclerView.OnFlingListener(){

                public boolean onFling(int velocityX, int velocityY) {
                    if (!this.isDisposed()) {
                        observer.onNext((Object)RecyclerViewFlingEvent.create(recyclerView, velocityX, velocityY));
                    }
                    return false;
                }
            };
        }

        protected void onDispose() {
            this.recyclerView.setOnFlingListener(null);
        }
    }
}

