/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.v7.widget;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.v7.widget.RecyclerViewChildAttachEvent;
import com.jakewharton.rxbinding2.support.v7.widget.RecyclerViewChildAttachStateChangeEvent;
import com.jakewharton.rxbinding2.support.v7.widget.RecyclerViewChildDetachEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RecyclerViewChildAttachStateChangeEventObservable
extends Observable<RecyclerViewChildAttachStateChangeEvent> {
    private final RecyclerView view;

    RecyclerViewChildAttachStateChangeEventObservable(RecyclerView recyclerView) {
        this.view = recyclerView;
    }

    protected void subscribeActual(Observer<? super RecyclerViewChildAttachStateChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)listener);
    }

    final class Listener
    extends MainThreadDisposable
    implements RecyclerView.OnChildAttachStateChangeListener {
        private final RecyclerView recyclerView;
        private final Observer<? super RecyclerViewChildAttachStateChangeEvent> observer;

        Listener(RecyclerView recyclerView, Observer<? super RecyclerViewChildAttachStateChangeEvent> observer) {
            this.recyclerView = recyclerView;
            this.observer = observer;
        }

        public void onChildViewAttachedToWindow(View childView) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)RecyclerViewChildAttachEvent.create(this.recyclerView, childView));
            }
        }

        public void onChildViewDetachedFromWindow(View childView) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)RecyclerViewChildDetachEvent.create(this.recyclerView, childView));
            }
        }

        protected void onDispose() {
            this.recyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this);
        }
    }
}

