/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.design.widget.TabLayout;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionEvent;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionReselectedEvent;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionSelectedEvent;
import com.jakewharton.rxbinding2.support.design.widget.TabLayoutSelectionUnselectedEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class TabLayoutSelectionEventObservable
extends Observable<TabLayoutSelectionEvent> {
    final TabLayout view;

    TabLayoutSelectionEventObservable(TabLayout view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super TabLayoutSelectionEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)listener);
        int index = this.view.getSelectedTabPosition();
        if (index != -1) {
            observer.onNext((Object)TabLayoutSelectionSelectedEvent.create(this.view, this.view.getTabAt(index)));
        }
    }

    final class Listener
    extends MainThreadDisposable
    implements TabLayout.OnTabSelectedListener {
        private final TabLayout tabLayout;
        private final Observer<? super TabLayoutSelectionEvent> observer;

        Listener(TabLayout tabLayout, Observer<? super TabLayoutSelectionEvent> observer) {
            this.tabLayout = tabLayout;
            this.observer = observer;
        }

        public void onTabSelected(TabLayout.Tab tab) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)TabLayoutSelectionSelectedEvent.create(TabLayoutSelectionEventObservable.this.view, tab));
            }
        }

        public void onTabUnselected(TabLayout.Tab tab) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)TabLayoutSelectionUnselectedEvent.create(TabLayoutSelectionEventObservable.this.view, tab));
            }
        }

        public void onTabReselected(TabLayout.Tab tab) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)TabLayoutSelectionReselectedEvent.create(TabLayoutSelectionEventObservable.this.view, tab));
            }
        }

        protected void onDispose() {
            this.tabLayout.removeOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
        }
    }
}

