/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.support.design.widget;

import android.support.design.widget.AppBarLayout;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AppBarLayoutOffsetChangeObservable
extends Observable<Integer> {
    private final AppBarLayout view;

    AppBarLayoutOffsetChangeObservable(AppBarLayout view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AppBarLayout.OnOffsetChangedListener {
        private final AppBarLayout appBarLayout;
        private final Observer<? super Integer> observer;

        Listener(AppBarLayout appBarLayout, Observer<? super Integer> observer) {
            this.appBarLayout = appBarLayout;
            this.observer = observer;
        }

        public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)verticalOffset);
            }
        }

        protected void onDispose() {
            this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        }
    }
}

