/*
 * Decompiled with CFR 0.152.
 */
package hugo.weaving.internal;

import android.os.Looper;
import android.util.Log;
import hugo.weaving.internal.Strings;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class Hugo {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ Hugo ajc$perSingletonInstance;

    @Pointcut(value="within(@hugo.weaving.DebugLog *)")
    public void withinAnnotatedClass() {
    }

    @Pointcut(value="execution(* *(..)) && withinAnnotatedClass()")
    public void methodInsideAnnotatedType() {
    }

    @Pointcut(value="execution(*.new(..)) && withinAnnotatedClass()")
    public void constructorInsideAnnotatedType() {
    }

    @Pointcut(value="execution(@hugo.weaving.DebugLog * *(..)) || methodInsideAnnotatedType()")
    public void method() {
    }

    @Pointcut(value="execution(@hugo.weaving.DebugLog *.new(..)) || constructorInsideAnnotatedType()")
    public void constructor() {
    }

    @Around(value="method() || constructor()")
    public Object logAndExecute(ProceedingJoinPoint joinPoint) throws Throwable {
        Hugo.enterMethod((JoinPoint)joinPoint);
        long startNanos = System.nanoTime();
        Object result = joinPoint.proceed();
        long stopNanos = System.nanoTime();
        long lengthMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - startNanos);
        Hugo.exitMethod((JoinPoint)joinPoint, result, lengthMillis);
        return result;
    }

    private static void enterMethod(JoinPoint joinPoint) {
        CodeSignature codeSignature = (CodeSignature)joinPoint.getSignature();
        Class cls = codeSignature.getDeclaringType();
        String methodName = codeSignature.getName();
        String[] parameterNames = codeSignature.getParameterNames();
        Object[] parameterValues = joinPoint.getArgs();
        StringBuilder builder = new StringBuilder("\u21e2 ");
        builder.append(methodName).append('(');
        for (int i = 0; i < parameterValues.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameterNames[i]).append('=');
            builder.append(Strings.toString(parameterValues[i]));
        }
        builder.append(')');
        if (Looper.myLooper() != Looper.getMainLooper()) {
            builder.append(" [Thread:\"").append(Thread.currentThread().getName()).append("\"]");
        }
        Log.v((String)Hugo.asTag(cls), (String)builder.toString());
    }

    private static void exitMethod(JoinPoint joinPoint, Object result, long lengthMillis) {
        Signature signature = joinPoint.getSignature();
        Class cls = signature.getDeclaringType();
        String methodName = signature.getName();
        boolean hasReturnType = signature instanceof MethodSignature && ((MethodSignature)signature).getReturnType() != Void.TYPE;
        StringBuilder builder = new StringBuilder("\u21e0 ").append(methodName).append(" [").append(lengthMillis).append("ms]");
        if (hasReturnType) {
            builder.append(" = ");
            builder.append(Strings.toString(result));
        }
        Log.v((String)Hugo.asTag(cls), (String)builder.toString());
    }

    private static String asTag(Class<?> cls) {
        if (cls.isAnonymousClass()) {
            return Hugo.asTag(cls.getEnclosingClass());
        }
        return cls.getSimpleName();
    }

    public static Hugo aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("hugo.weaving.internal.Hugo", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            Hugo.ajc$perSingletonInstance = new Hugo();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

