/*
 * Decompiled with CFR 0.152.
 */
package com.jakebarnby.simpleml.camera2.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001'B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0014J\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0012J\b\u0010&\u001a\u00020\u001dH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "graphics", "", "Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay$Graphic;", "<set-?>", "", "imageHeight", "getImageHeight", "()I", "imageWidth", "getImageWidth", "isImageFlipped", "", "lock", "", "needUpdateTransformation", "postScaleHeightOffset", "", "postScaleWidthOffset", "scaleFactor", "transformationMatrix", "Landroid/graphics/Matrix;", "add", "", "graphic", "clear", "onDraw", "canvas", "Landroid/graphics/Canvas;", "remove", "setImageSourceInfo", "isFlipped", "updateTransformationIfNeeded", "Graphic", "simpleml-core_release"})
public final class GraphicOverlay
extends View {
    private final Object lock = new Object();
    private final List<Graphic> graphics = new ArrayList();
    private final Matrix transformationMatrix = new Matrix();
    private int imageWidth;
    private int imageHeight;
    private float scaleFactor = 1.0f;
    private float postScaleWidthOffset;
    private float postScaleHeightOffset;
    private boolean isImageFlipped;
    private boolean needUpdateTransformation = true;

    public final int getImageWidth() {
        return this.imageWidth;
    }

    public final int getImageHeight() {
        return this.imageHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.graphics.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull Graphic graphic) {
        Intrinsics.checkNotNullParameter((Object)graphic, (String)"graphic");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.graphics.add(graphic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull Graphic graphic) {
        Intrinsics.checkNotNullParameter((Object)graphic, (String)"graphic");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.graphics.remove(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setImageSourceInfo(int imageWidth, int imageHeight, boolean isFlipped) {
        boolean bl = imageWidth > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "image width must be positive";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = imageHeight > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "image height must be positive";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object = this.lock;
        bl2 = false;
        bl3 = false;
        synchronized (object) {
            boolean bl6 = false;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.isImageFlipped = isFlipped;
            this.needUpdateTransformation = true;
            Unit unit = Unit.INSTANCE;
        }
        this.postInvalidate();
    }

    private final void updateTransformationIfNeeded() {
        if (!this.needUpdateTransformation || this.imageWidth <= 0 || this.imageHeight <= 0) {
            return;
        }
        float viewAspectRatio = (float)this.getWidth() / (float)this.getHeight();
        float imageAspectRatio = (float)this.imageWidth / (float)this.imageHeight;
        this.postScaleWidthOffset = 0.0f;
        this.postScaleHeightOffset = 0.0f;
        if (viewAspectRatio > imageAspectRatio) {
            this.scaleFactor = (float)this.getWidth() / (float)this.imageWidth;
            this.postScaleHeightOffset = ((float)this.getWidth() / imageAspectRatio - (float)this.getHeight()) / (float)2;
        } else {
            this.scaleFactor = (float)this.getHeight() / (float)this.imageHeight;
            this.postScaleWidthOffset = ((float)this.getHeight() * imageAspectRatio - (float)this.getWidth()) / (float)2;
        }
        this.transformationMatrix.reset();
        this.transformationMatrix.setScale(this.scaleFactor, this.scaleFactor);
        this.transformationMatrix.postTranslate(-this.postScaleWidthOffset, -this.postScaleHeightOffset);
        if (this.isImageFlipped) {
            this.transformationMatrix.postScale(-1.0f, 1.0f, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        }
        this.needUpdateTransformation = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.updateTransformationIfNeeded();
            for (Graphic graphic : this.graphics) {
                graphic.draw(canvas);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public GraphicOverlay(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public final void onLayoutChange(@Nullable View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                needUpdateTransformation = true;
            }
        });
    }

    public static final /* synthetic */ void access$setScaleFactor$p(GraphicOverlay $this, float f) {
        $this.scaleFactor = f;
    }

    public static final /* synthetic */ void access$setImageFlipped$p(GraphicOverlay $this, boolean bl) {
        $this.isImageFlipped = bl;
    }

    public static final /* synthetic */ void access$setPostScaleWidthOffset$p(GraphicOverlay $this, float f) {
        $this.postScaleWidthOffset = f;
    }

    public static final /* synthetic */ void access$setPostScaleHeightOffset$p(GraphicOverlay $this, float f) {
        $this.postScaleHeightOffset = f;
    }

    public static final /* synthetic */ boolean access$getNeedUpdateTransformation$p(GraphicOverlay $this) {
        return $this.needUpdateTransformation;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH&J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay$Graphic;", "", "overlay", "Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay;", "(Lcom/jakebarnby/simpleml/camera2/view/GraphicOverlay;)V", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getTransformationMatrix", "Landroid/graphics/Matrix;", "isImageFlipped", "", "postInvalidate", "scale", "", "imagePixel", "translateX", "x", "translateY", "y", "simpleml-core_release"})
    public static abstract class Graphic {
        private final GraphicOverlay overlay;

        public abstract void draw(@Nullable Canvas var1);

        public final float scale(float imagePixel) {
            return imagePixel * this.overlay.scaleFactor;
        }

        @NotNull
        public final Context getApplicationContext() {
            Context context = this.overlay.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"overlay.context");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"overlay.context.applicationContext");
            return context2;
        }

        public final boolean isImageFlipped() {
            return this.overlay.isImageFlipped;
        }

        public final float translateX(float x) {
            return this.overlay.isImageFlipped ? (float)this.overlay.getWidth() - (this.scale(x) - this.overlay.postScaleWidthOffset) : this.scale(x) - this.overlay.postScaleWidthOffset;
        }

        public final float translateY(float y) {
            return this.scale(y) - this.overlay.postScaleHeightOffset;
        }

        @NotNull
        public final Matrix getTransformationMatrix() {
            return this.overlay.transformationMatrix;
        }

        public final void postInvalidate() {
            this.overlay.postInvalidate();
        }

        public Graphic(@NotNull GraphicOverlay overlay) {
            Intrinsics.checkNotNullParameter((Object)((Object)overlay), (String)"overlay");
            this.overlay = overlay;
        }
    }
}

