/*
 * Decompiled with CFR 0.152.
 */
package com.jaeger.library;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.jaeger.library.StatusBarView;

public class StatusBarUtil {
    public static final int DEFAULT_STATUS_BAR_ALPHA = 112;

    public static void setColor(Activity activity, int color) {
        StatusBarUtil.setColor(activity, color, 112);
    }

    public static void setColor(Activity activity, int color, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
            int count = decorView.getChildCount();
            if (count > 0 && decorView.getChildAt(count - 1) instanceof StatusBarView) {
                decorView.getChildAt(count - 1).setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
            } else {
                StatusBarView statusView = StatusBarUtil.createStatusBarView(activity, color, statusBarAlpha);
                decorView.addView((View)statusView);
            }
            StatusBarUtil.setRootView(activity);
        }
    }

    public static void setColorNoTranslucent(Activity activity, int color) {
        StatusBarUtil.setColor(activity, color, 0);
    }

    @Deprecated
    public static void setColorDiff(Activity activity, int color) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        activity.getWindow().addFlags(0x4000000);
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        int count = decorView.getChildCount();
        if (count > 0 && decorView.getChildAt(count - 1) instanceof StatusBarView) {
            decorView.getChildAt(count - 1).setBackgroundColor(color);
        } else {
            StatusBarView statusView = StatusBarUtil.createStatusBarView(activity, color);
            decorView.addView((View)statusView);
        }
        StatusBarUtil.setRootView(activity);
    }

    public static void setTranslucent(Activity activity) {
        StatusBarUtil.setTranslucent(activity, 112);
    }

    public static void setTranslucent(Activity activity, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        StatusBarUtil.setTransparent(activity);
        StatusBarUtil.addTranslucentView(activity, statusBarAlpha);
    }

    public static void setTransparent(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        StatusBarUtil.transparentStatusBar(activity);
        StatusBarUtil.setRootView(activity);
    }

    @Deprecated
    public static void setTranslucentDiff(Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            StatusBarUtil.setRootView(activity);
        }
    }

    public static void setColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, int color) {
        StatusBarUtil.setColorForDrawerLayout(activity, drawerLayout, color, 112);
    }

    public static void setColorNoTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout, int color) {
        StatusBarUtil.setColorForDrawerLayout(activity, drawerLayout, color, 0);
    }

    public static void setColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, int color, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        if (contentLayout.getChildCount() > 0 && contentLayout.getChildAt(0) instanceof StatusBarView) {
            contentLayout.getChildAt(0).setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
        } else {
            StatusBarView statusBarView = StatusBarUtil.createStatusBarView(activity, color);
            contentLayout.addView((View)statusBarView, 0);
        }
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            contentLayout.getChildAt(1).setPadding(0, StatusBarUtil.getStatusBarHeight((Context)activity), 0, 0);
        }
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        contentLayout.setFitsSystemWindows(false);
        contentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
        StatusBarUtil.addTranslucentView(activity, statusBarAlpha);
    }

    @Deprecated
    public static void setColorForDrawerLayoutDiff(Activity activity, DrawerLayout drawerLayout, int color) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
            if (contentLayout.getChildCount() > 0 && contentLayout.getChildAt(0) instanceof StatusBarView) {
                contentLayout.getChildAt(0).setBackgroundColor(StatusBarUtil.calculateStatusColor(color, 112));
            } else {
                StatusBarView statusBarView = StatusBarUtil.createStatusBarView(activity, color);
                contentLayout.addView((View)statusBarView, 0);
            }
            if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
                contentLayout.getChildAt(1).setPadding(0, StatusBarUtil.getStatusBarHeight((Context)activity), 0, 0);
            }
            ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
            drawerLayout.setFitsSystemWindows(false);
            contentLayout.setFitsSystemWindows(false);
            contentLayout.setClipToPadding(true);
            drawer.setFitsSystemWindows(false);
        }
    }

    public static void setTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout) {
        StatusBarUtil.setTranslucentForDrawerLayout(activity, drawerLayout, 112);
    }

    public static void setTranslucentForDrawerLayout(Activity activity, DrawerLayout drawerLayout, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        StatusBarUtil.setTransparentForDrawerLayout(activity, drawerLayout);
        StatusBarUtil.addTranslucentView(activity, statusBarAlpha);
    }

    public static void setTransparentForDrawerLayout(Activity activity, DrawerLayout drawerLayout) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            contentLayout.getChildAt(1).setPadding(0, StatusBarUtil.getStatusBarHeight((Context)activity), 0, 0);
        }
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        contentLayout.setFitsSystemWindows(false);
        contentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
    }

    @Deprecated
    public static void setTranslucentForDrawerLayoutDiff(Activity activity, DrawerLayout drawerLayout) {
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
            contentLayout.setFitsSystemWindows(true);
            contentLayout.setClipToPadding(true);
            ViewGroup vg = (ViewGroup)drawerLayout.getChildAt(1);
            vg.setFitsSystemWindows(false);
            drawerLayout.setFitsSystemWindows(false);
        }
    }

    public static void setTranslucentForImageView(Activity activity, View needOffsetView) {
        StatusBarUtil.setTranslucentForImageView(activity, 112, needOffsetView);
    }

    public static void setTranslucentForImageView(Activity activity, int statusBarAlpha, View needOffsetView) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setStatusBarColor(0);
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
        } else {
            activity.getWindow().setFlags(0x4000000, 0x4000000);
        }
        StatusBarUtil.addTranslucentView(activity, statusBarAlpha);
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)needOffsetView.getLayoutParams();
        layoutParams.setMargins(0, StatusBarUtil.getStatusBarHeight((Context)activity), 0, 0);
    }

    private static void addTranslucentView(Activity activity, int statusBarAlpha) {
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        if (contentView.getChildCount() > 1) {
            contentView.getChildAt(1).setBackgroundColor(Color.argb((int)statusBarAlpha, (int)0, (int)0, (int)0));
        } else {
            contentView.addView((View)StatusBarUtil.createTranslucentStatusBarView(activity, statusBarAlpha));
        }
    }

    private static StatusBarView createStatusBarView(Activity activity, int color) {
        StatusBarView statusBarView = new StatusBarView((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(color);
        return statusBarView;
    }

    private static StatusBarView createStatusBarView(Activity activity, int color, int alpha) {
        StatusBarView statusBarView = new StatusBarView((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, alpha));
        return statusBarView;
    }

    private static void setRootView(Activity activity) {
        ViewGroup rootView = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        rootView.setFitsSystemWindows(true);
        rootView.setClipToPadding(true);
    }

    @TargetApi(value=19)
    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
    }

    private static StatusBarView createTranslucentStatusBarView(Activity activity, int alpha) {
        StatusBarView statusBarView = new StatusBarView((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        return statusBarView;
    }

    private static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static int calculateStatusColor(int color, int alpha) {
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

