/*
 * Decompiled with CFR 0.152.
 */
package com.jaeger.ninegridimageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.jaeger.ninegridimageview.NineGridImageViewAdapter;
import com.jaeger.ninegridimageview.R;
import java.util.ArrayList;
import java.util.List;

public class NineGridImageView<T>
extends ViewGroup {
    public static final int STYLE_GRID = 0;
    public static final int STYLE_FILL = 1;
    private int mRowCount;
    private int mColumnCount;
    private int mMaxSize;
    private int mShowStyle;
    private int mGap;
    private int mSingleImgSize;
    private int mGridSize;
    private List<ImageView> mImageViewList = new ArrayList<ImageView>();
    private List<T> mImgDataList;
    private NineGridImageViewAdapter<T> mAdapter;

    public NineGridImageView(Context context) {
        this(context, null);
    }

    public NineGridImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NineGridImageView);
        this.mGap = (int)typedArray.getDimension(R.styleable.NineGridImageView_imgGap, 0.0f);
        this.mSingleImgSize = typedArray.getDimensionPixelSize(R.styleable.NineGridImageView_singleImgSize, -1);
        this.mShowStyle = typedArray.getInt(R.styleable.NineGridImageView_showStyle, 0);
        this.mMaxSize = typedArray.getInt(R.styleable.NineGridImageView_maxSize, 9);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int totalWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        if (this.mImgDataList != null && this.mImgDataList.size() > 0) {
            if (this.mImgDataList.size() == 1 && this.mSingleImgSize != -1) {
                this.mGridSize = this.mSingleImgSize > totalWidth ? totalWidth : this.mSingleImgSize;
            } else {
                this.mImageViewList.get(0).setScaleType(ImageView.ScaleType.CENTER_CROP);
                this.mGridSize = (totalWidth - this.mGap * (this.mColumnCount - 1)) / this.mColumnCount;
            }
            int height = this.mGridSize * this.mRowCount + this.mGap * (this.mRowCount - 1) + this.getPaddingTop() + this.getPaddingBottom();
            this.setMeasuredDimension(width, height);
        } else {
            int height = width;
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutChildrenView();
    }

    private void layoutChildrenView() {
        if (this.mImgDataList == null) {
            return;
        }
        int showCount = this.getNeedShowCount(this.mImgDataList.size());
        for (int i = 0; i < showCount; ++i) {
            ImageView childrenView = (ImageView)this.getChildAt(i);
            if (this.mAdapter != null) {
                this.mAdapter.onDisplayImage(this.getContext(), childrenView, this.mImgDataList.get(i));
            }
            int rowNum = i / this.mColumnCount;
            int columnNum = i % this.mColumnCount;
            int left = (this.mGridSize + this.mGap) * columnNum + this.getPaddingLeft();
            int top = (this.mGridSize + this.mGap) * rowNum + this.getPaddingTop();
            int right = left + this.mGridSize;
            int bottom = top + this.mGridSize;
            childrenView.layout(left, top, right, bottom);
        }
    }

    public void setImagesData(List lists) {
        if (lists == null || lists.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        int newShowCount = this.getNeedShowCount(lists.size());
        int[] gridParam = NineGridImageView.calculateGridParam(newShowCount, this.mShowStyle);
        this.mRowCount = gridParam[0];
        this.mColumnCount = gridParam[1];
        if (this.mImgDataList == null) {
            for (int i = 0; i < newShowCount; ++i) {
                ImageView iv = this.getImageView(i);
                if (iv == null) {
                    return;
                }
                this.addView((View)iv, this.generateDefaultLayoutParams());
            }
        } else {
            int oldShowCount = this.getNeedShowCount(this.mImgDataList.size());
            if (oldShowCount > newShowCount) {
                this.removeViews(newShowCount, oldShowCount - newShowCount);
            } else if (oldShowCount < newShowCount) {
                for (int i = oldShowCount; i < newShowCount; ++i) {
                    ImageView iv = this.getImageView(i);
                    if (iv == null) {
                        return;
                    }
                    this.addView((View)iv, this.generateDefaultLayoutParams());
                }
            }
        }
        this.mImgDataList = lists;
        this.requestLayout();
    }

    private int getNeedShowCount(int size) {
        if (this.mMaxSize > 0 && size > this.mMaxSize) {
            return this.mMaxSize;
        }
        return size;
    }

    private ImageView getImageView(final int position) {
        if (position < this.mImageViewList.size()) {
            return this.mImageViewList.get(position);
        }
        if (this.mAdapter != null) {
            ImageView imageView = this.mAdapter.generateImageView(this.getContext());
            this.mImageViewList.add(imageView);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NineGridImageView.this.mAdapter.onItemImageClick(NineGridImageView.this.getContext(), position, NineGridImageView.this.mImgDataList);
                }
            });
            return imageView;
        }
        Log.e((String)"NineGirdImageView", (String)"Your must set a NineGridImageViewAdapter for NineGirdImageView");
        return null;
    }

    protected static int[] calculateGridParam(int imagesSize, int showStyle) {
        int[] gridParam = new int[2];
        switch (showStyle) {
            case 1: {
                if (imagesSize < 3) {
                    gridParam[0] = 1;
                    gridParam[1] = imagesSize;
                    break;
                }
                if (imagesSize <= 4) {
                    gridParam[0] = 2;
                    gridParam[1] = 2;
                    break;
                }
                gridParam[0] = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
                gridParam[1] = 3;
                break;
            }
            default: {
                gridParam[0] = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
                gridParam[1] = 3;
            }
        }
        return gridParam;
    }

    public void setAdapter(NineGridImageViewAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void setGap(int gap) {
        this.mGap = gap;
    }

    public void setShowStyle(int showStyle) {
        this.mShowStyle = showStyle;
    }

    public void setSingleImgSize(int singleImgSize) {
        this.mSingleImgSize = singleImgSize;
    }

    public void setMaxSize(int maxSize) {
        this.mMaxSize = maxSize;
    }
}

