/*
 * Decompiled with CFR 0.152.
 */
package kukri.util.extension;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u001a0\u0010\b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\u0007*\u00020\u00072\b\b\u0001\u0010\r\u001a\u00020\u0001\u001a\u001a\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0016"}, d2={"calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "w", "h", "screenshot", "Landroid/graphics/Bitmap;", "decode", "res", "Landroid/content/res/Resources;", "resId", "drawColor", "color", "resize", "scaleRatioW", "", "scaleRatioH", "toBitmap", "Landroid/graphics/drawable/Drawable;", "toDrawable", "Landroid/graphics/drawable/BitmapDrawable;", "util_release"})
public final class ImageKt {
    @NotNull
    public static final Bitmap drawColor(@NotNull Bitmap $receiver, @ColorInt int color) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.isMutable()) {
            Canvas canvas = new Canvas($receiver);
            canvas.drawColor(color);
        }
        return $receiver;
    }

    @NotNull
    public static final Bitmap resize(@NotNull Bitmap $receiver, float scaleRatioW, float scaleRatioH) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Matrix matrix = new Matrix();
        matrix.postScale(scaleRatioW, scaleRatioH);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)$receiver, (int)0, (int)0, (int)$receiver.getWidth(), (int)$receiver.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(this\u2026th, height, matrix, true)");
        return bitmap;
    }

    @NotNull
    public static final BitmapDrawable toDrawable(@NotNull Bitmap $receiver, @NotNull Resources res) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        return new BitmapDrawable(res, $receiver);
    }

    @NotNull
    public static final Bitmap decode(@NotNull Bitmap $receiver, @NotNull Resources res, @DrawableRes int resId, int w, int h) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = ImageKt.calculateInSampleSize(options, w, h);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeResource(res, resId, options)");
        return bitmap;
    }

    @NotNull
    public static /* synthetic */ Bitmap decode$default(Bitmap bitmap, Resources resources, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return ImageKt.decode(bitmap, resources, n, n2, n3);
    }

    private static final int calculateInSampleSize(BitmapFactory.Options options, int w, int h) {
        int inSampleSize = 1;
        if (options.outWidth > w || options.outHeight > h) {
            int widthRatio = Math.round((float)options.outWidth / (float)w);
            int heightRatio = Math.round((float)options.outHeight / (float)h);
            inSampleSize = Math.max(widthRatio, heightRatio);
        }
        return inSampleSize;
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Drawable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Bitmap.Config config = $receiver.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)$receiver.getIntrinsicWidth(), (int)$receiver.getIntrinsicHeight(), (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        $receiver.setBounds(0, 0, $receiver.getIntrinsicWidth(), $receiver.getIntrinsicHeight());
        $receiver.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @SuppressLint(value={"PrivateApi"})
    @Nullable
    public static final Bitmap screenshot(int w, int h) {
        Bitmap bitmap = null;
        try {
            Class<?> clazz;
            if (Build.VERSION.SDK_INT >= 18) {
                Class<?> clazz2 = Class.forName("android.view.SurfaceControl");
                clazz = clazz2;
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(\"android.view.SurfaceControl\")");
            } else {
                Class<?> clazz3 = Class.forName("android.view.Surface");
                clazz = clazz3;
                Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"Class.forName(\"android.view.Surface\")");
            }
            Class<?> matrix = clazz;
            Method method = matrix.getMethod("screenshot", Integer.TYPE, Integer.TYPE);
            Object object = method.invoke(null, w, h);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
            }
            bitmap = (Bitmap)object;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return bitmap;
    }
}

