/*
 * Decompiled with CFR 0.152.
 */
package com.jack.test.logger;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import com.jack.test.logger.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogView
extends TextView
implements Log.LogNode {
    private Log.LogNode mNext;

    public LogView(Context context) {
        super(context);
    }

    public LogView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LogView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public Log.LogNode getNext() {
        return this.mNext;
    }

    public void setNext(Log.LogNode node) {
        this.mNext = node;
    }

    @Override
    public void println(int priority, String tag, String msg, Throwable tr) {
        String priorityStr = null;
        switch (priority) {
            case 3: {
                priorityStr = "D";
                break;
            }
            case 4: {
                priorityStr = "I";
                break;
            }
            case 5: {
                priorityStr = "W";
                break;
            }
            case 6: {
                priorityStr = "E";
                break;
            }
        }
        String exceptionStr = null;
        if (tr != null) {
            exceptionStr = Log.getStackTraceString((Throwable)tr);
        }
        final StringBuilder outputBuilder = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date curDate = new Date(System.currentTimeMillis());
        String str = formatter.format(curDate);
        outputBuilder.append(priorityStr + " ");
        outputBuilder.append(str);
        outputBuilder.append(" ");
        outputBuilder.append(msg);
        outputBuilder.append("\r\n");
        ((Activity)this.getContext()).runOnUiThread((Runnable)new Thread(new Runnable(){

            @Override
            public void run() {
                LogView.this.appendToLog(outputBuilder.toString());
            }
        }));
        if (this.mNext != null) {
            this.mNext.println(priority, tag, msg, tr);
        }
    }

    public void appendToLog(String s) {
        this.append("\n" + s);
    }

    private StringBuilder appendIfNotNull(StringBuilder source, String addStr, String delimiter) {
        if (addStr != null) {
            if (addStr.length() == 0) {
                delimiter = "";
            }
            return source.append(addStr).append(delimiter);
        }
        return source;
    }
}

