/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.table;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.jacky.log.Logger;
import com.jacky.table.Column;
import com.jacky.table.DBType;
import com.jacky.table.DatabaseException;
import com.jacky.table.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class DBManager {
    private SQLiteDatabase mDatabase;
    private boolean isBeginTransaction;
    private static final boolean showLog = false;

    public DBManager(Context context, String name) {
        this(context.openOrCreateDatabase(name, 0, null));
    }

    public DBManager(SQLiteDatabase db) {
        this.mDatabase = db;
    }

    public void close() {
        if (this.mDatabase != null) {
            this.mDatabase.close();
        }
        this.mDatabase = null;
    }

    public void createTables(Context context, Class<?> ... classes) {
        if (this.mDatabase == null || classes == null || classes.length == 0) {
            return;
        }
        File file = new File(this.mDatabase.getPath());
        String dbName = file.getName();
        Properties properties = new Properties();
        File preferences = new File(file.getParent(), "jacky_db");
        if (preferences.exists() && preferences.canRead()) {
            try {
                properties.load(new FileInputStream(preferences));
            }
            catch (IOException e) {
                Logger.e((Object)e);
            }
        }
        this.beginTransaction();
        for (Class<?> clazz : classes) {
            Table table = DBManager.getTable(clazz);
            Field[] fields = clazz.getDeclaredFields();
            if (fields.length <= 0) continue;
            String tableName = table.value();
            String createSql = this.generateCreateTableSql(table, fields);
            String sqlVersion = String.valueOf(createSql.hashCode());
            String preferencesKey = "SQL_" + dbName + '_' + tableName;
            Map<String, String> map = this.queryTableColumnsInfo(this.mDatabase, tableName);
            if (map == null) {
                this.mDatabase.execSQL(createSql);
            } else {
                String version = properties.getProperty(preferencesKey);
                if (sqlVersion != null && sqlVersion.equals(version)) continue;
                StringBuilder sb = new StringBuilder();
                for (Field field : fields) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    DBType type = DBManager.getDBType(column, field.getType());
                    String value = map.get(column.value());
                    if (!type.name().equals(value)) continue;
                    sb.append(',').append(column.value());
                }
                if (sb.length() == 0) {
                    this.mDatabase.execSQL(createSql);
                } else {
                    String t = sb.deleteCharAt(0).toString();
                    this.mDatabase.execSQL("ALTER TABLE " + tableName + " RENAME TO TEMPN");
                    this.mDatabase.execSQL(createSql);
                    this.mDatabase.execSQL("REPLACE INTO " + tableName + "(" + t + ") SELECT " + t + " FROM TEMPN");
                    this.mDatabase.execSQL("DROP TABLE TEMPN");
                }
            }
            properties.setProperty(preferencesKey, String.valueOf(sqlVersion));
        }
        this.setTransactionSuccessful();
        this.endTransaction();
        try {
            if (!preferences.exists()) {
                preferences.getParentFile().mkdirs();
                preferences.createNewFile();
            }
            properties.store(new FileOutputStream(preferences), "");
        }
        catch (IOException e) {
            Logger.e((Object)e);
        }
    }

    public boolean isTableExit(Class clazz) {
        if (this.mDatabase == null || clazz == null) {
            return false;
        }
        String name = DBManager.getTableName(clazz);
        Cursor cursor = this.mDatabase.rawQuery("SELECT 1 FROM sqlite_master WHERE NAME='" + name + "'", null);
        if (cursor == null) {
            return false;
        }
        int i = 0;
        if (0 != cursor.getCount()) {
            cursor.moveToFirst();
            i = cursor.getInt(0);
        }
        cursor.close();
        return i > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> queryTableColumnsInfo(SQLiteDatabase db, String table) {
        try (Cursor cursor = null;){
            cursor = db.rawQuery("PRAGMA TABLE_INFO(" + table + ")", null);
            if (cursor.getCount() > 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                while (cursor.moveToNext()) {
                    int index = cursor.getColumnIndex("name");
                    String key = cursor.getString(index);
                    index = cursor.getColumnIndex("type");
                    map.put(key, cursor.getString(index));
                }
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            Map<String, String> map = null;
            return map;
        }
    }

    private final String generateCreateTableSql(Table table, Field[] fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS '").append(table.value()).append("'(");
        boolean hasId = false;
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            DBType type = DBManager.getDBType(column, field.getType());
            if (column.isPrimary()) {
                if (hasId) {
                    throw new DatabaseException("Primary key had in the table,set isPrimary is false.");
                }
                hasId = true;
                sb.append(column.value()).append(' ').append(type.value());
                if (table.autoId()) {
                    sb.append(" PRIMARY KEY AUTOINCREMENT,");
                    continue;
                }
                sb.append(" PRIMARY KEY,");
                continue;
            }
            sb.append(column.value()).append(' ').append(type).append(" DEFAULT '").append(column.defValue()).append("',");
        }
        if (!hasId && table.autoId()) {
            throw new DatabaseException("No primary key in the Table " + table.value());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public <T> void insert(List<T> list) {
        this.insert(list.toArray());
    }

    public <T> void insert(T ... list) {
        if (this.mDatabase == null || list == null || list.length <= 0 || list[0] == null) {
            return;
        }
        Class<?> clazz = list[0].getClass();
        Table table = DBManager.getTable(clazz);
        Field[] fields = clazz.getDeclaredFields();
        this.beginTransaction();
        ContentValues values = null;
        try {
            for (T t : list) {
                if (t == null) continue;
                DBManager.checkClass(t, clazz);
                Field idField = null;
                values = new ContentValues();
                for (Field field : fields) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    if (table.autoId() && column.isPrimary()) {
                        idField = field;
                        continue;
                    }
                    String tmp = DBManager.getFieldValue(clazz, column, field, t);
                    if (tmp == null) continue;
                    values.put(column.value(), tmp);
                }
                long id = this.mDatabase.insertOrThrow(table.value(), null, values);
                if (idField == null || id == -1L) continue;
                DBManager.setObjectValue(idField, t, id);
            }
        }
        catch (SQLException e) {
            throw new SQLException(values.toString(), (Throwable)e);
        }
        finally {
            this.setTransactionSuccessful();
            this.endTransaction();
        }
    }

    public <T> void replaceInto(List<T> list) {
        this.replaceInto(list, (String[])null);
    }

    public <T> void replaceInto(T ... list) {
        this.replaceInto(list, (String[])null);
    }

    public <T> void replaceInto(List<T> list, String[] ignoreColumn) {
        this.replaceInto(list.toArray(), ignoreColumn);
    }

    public <T> void replaceInto(T[] list, String[] ignoreColumn) {
        if (this.mDatabase == null || list == null || list.length <= 0 || list[0] == null) {
            return;
        }
        Class<?> clazz = list[0].getClass();
        Table table = DBManager.getTable(clazz);
        Field[] fields = clazz.getDeclaredFields();
        String whereClause = this.getPrimaryColumn(clazz, true).value() + "=?";
        String id = null;
        this.beginTransaction();
        ContentValues values = null;
        try {
            for (T t : list) {
                if (t == null) continue;
                DBManager.checkClass(t, clazz);
                Field idField = null;
                values = new ContentValues();
                for (Field field : fields) {
                    String tmp;
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    if (column.isPrimary()) {
                        id = DBManager.getFieldValue(clazz, column, field, t);
                        if (table.autoId()) {
                            idField = field;
                            continue;
                        }
                    }
                    if (DBManager.isIgnoreColumn(ignoreColumn, column) || (tmp = DBManager.getFieldValue(clazz, column, field, t)) == null) continue;
                    values.put(column.value(), tmp);
                }
                int i = this.mDatabase.update(table.value(), values, whereClause, new String[]{id});
                if (i != 0) continue;
                long newid = this.mDatabase.insertOrThrow(table.value(), null, values);
                if (idField == null || newid == -1L) continue;
                DBManager.setObjectValue(idField, t, newid);
            }
        }
        catch (SQLException ee) {
            throw new SQLException(values.toString(), (Throwable)ee);
        }
        finally {
            this.setTransactionSuccessful();
            this.endTransaction();
        }
    }

    public <T> void update(T ... list) {
        this.update(list, (String[])null);
    }

    public <T> void update(T[] list, String[] ignoreColumn) {
        if (this.mDatabase == null || list == null || list.length == 0) {
            return;
        }
        Class<?> clazz = list[0].getClass();
        String whereClause = this.getPrimaryColumn(clazz, true).value() + "=?";
        String id = null;
        String tmp = null;
        String tableName = DBManager.getTableName(clazz);
        this.beginTransaction();
        for (T t : list) {
            if (t == null) continue;
            DBManager.checkClass(t, clazz);
            ContentValues values = new ContentValues();
            for (Field field : clazz.getDeclaredFields()) {
                Column column = field.getAnnotation(Column.class);
                if (column == null || DBManager.isIgnoreColumn(ignoreColumn, column)) continue;
                tmp = DBManager.getFieldValue(clazz, column, field, t);
                if (column.isPrimary()) {
                    id = tmp;
                    continue;
                }
                if (tmp == null) continue;
                values.put(column.value(), tmp);
            }
            this.mDatabase.update(tableName, values, whereClause, new String[]{id});
        }
        this.setTransactionSuccessful();
        this.endTransaction();
    }

    public <T> void updateByWhere(T t, String[] ignoreColumn, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return;
        }
        ContentValues values = DBManager.getContentValues(t, ignoreColumn);
        this.mDatabase.update(DBManager.getTableName(t.getClass()), values, whereClause, whereArgs);
    }

    public <T> void updateByValues(Class<T> clazz, ContentValues values, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return;
        }
        int i = this.mDatabase.update(DBManager.getTableName(clazz), values, whereClause, whereArgs);
        Logger.d((Object[])new Object[]{"update result:", i});
    }

    public <T> void replaceIntoValues(Class<T> clazz, ContentValues values, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return;
        }
        String table = DBManager.getTableName(clazz);
        int i = this.mDatabase.update(table, values, whereClause, whereArgs);
        if (i == 0) {
            try {
                this.mDatabase.insertOrThrow(table, null, values);
            }
            catch (SQLException e) {
                throw new SQLException(values.toString(), (Throwable)e);
            }
        }
    }

    public static <T> ContentValues getContentValues(T t, String[] ignoreColumn) {
        Class<?> clazz = t.getClass();
        ContentValues values = new ContentValues();
        for (Field field : clazz.getDeclaredFields()) {
            String tmp;
            Column column = field.getAnnotation(Column.class);
            if (column == null || DBManager.isIgnoreColumn(ignoreColumn, column) || (tmp = DBManager.getFieldValue(clazz, column, field, t)) == null) continue;
            values.put(column.value(), tmp);
        }
        return values;
    }

    public <T> void delete(T ... list) {
        if (this.mDatabase == null || list == null || list.length == 0) {
            return;
        }
        Class<?> clazz = list[0].getClass();
        Table table = DBManager.getTable(clazz);
        Field[] fields = clazz.getDeclaredFields();
        this.beginTransaction();
        String whereClause = null;
        String[] whereArgs = null;
        for (T t : list) {
            int i;
            if (t == null) continue;
            DBManager.checkClass(t, clazz);
            if (whereClause == null) {
                i = 0;
                StringBuilder clause = new StringBuilder();
                Field[] fieldArray = fields;
                int n = fieldArray.length;
                for (int j = 0; j < n; ++j) {
                    Field field = fieldArray[j];
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    clause.append(column.value()).append("=? and ");
                    ++i;
                }
                clause.append("1=1");
                whereClause = clause.toString();
                whereArgs = new String[i];
            }
            i = 0;
            for (Field field : fields) {
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                whereArgs[i++] = DBManager.getFieldValue(clazz, column, field, t);
            }
            this.mDatabase.delete(table.value(), whereClause, whereArgs);
        }
        this.setTransactionSuccessful();
        this.endTransaction();
    }

    public void deleteAll(Class<?> clazz) {
        this.deleteByWhere(clazz, null, null);
    }

    public void deleteByWhere(Class<?> clazz, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return;
        }
        this.mDatabase.delete(DBManager.getTableName(clazz), whereClause, whereArgs);
    }

    public void deleteByID(Class<?> clazz, String ... id) {
        if (this.mDatabase == null) {
            return;
        }
        String whereClause = this.getPrimaryColumn(clazz, true).value() + "=?";
        String table = DBManager.getTableName(clazz);
        this.beginTransaction();
        for (String i : id) {
            this.mDatabase.delete(table, whereClause, new String[]{i});
        }
        this.setTransactionSuccessful();
        this.endTransaction();
    }

    public <T> List<T> query(Class<T> clazz) {
        return this.queryByWhere(clazz, null, null);
    }

    public <T> T queryById(Class<T> clazz, String id) {
        if (this.mDatabase == null) {
            return null;
        }
        String whereClause = null;
        for (Field field : clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !column.isPrimary()) continue;
            whereClause = column.value() + "=? limit 1";
            break;
        }
        if (whereClause == null) {
            throw new DatabaseException("This table no primary key.");
        }
        Cursor cursor = this.mDatabase.rawQuery("SELECT * FROM " + DBManager.getTableName(clazz) + " WHERE " + whereClause, new String[]{id});
        T t = null;
        if (cursor.moveToNext()) {
            t = DBManager.buildObject(clazz, cursor, null);
        }
        cursor.close();
        return t;
    }

    public <T> List<T> queryByWhere(Class<T> clazz, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return new ArrayList();
        }
        String table = DBManager.getTableName(clazz);
        Cursor cursor = TextUtils.isEmpty((CharSequence)whereClause) ? this.mDatabase.rawQuery("SELECT * FROM " + table, null) : this.mDatabase.rawQuery("SELECT * FROM " + table + " WHERE " + whereClause, whereArgs);
        List<T> list = DBManager.reflectObject(clazz, cursor);
        cursor.close();
        return list;
    }

    public <T> Cursor getQueryCursor(Class<T> clazz, String whereClause, String[] whereArgs) {
        if (this.mDatabase == null) {
            return null;
        }
        String table = DBManager.getTableName(clazz);
        Cursor cursor = TextUtils.isEmpty((CharSequence)whereClause) ? this.mDatabase.rawQuery("SELECT * FROM " + table, null) : this.mDatabase.rawQuery("SELECT * FROM " + table + " WHERE " + whereClause, whereArgs);
        return cursor;
    }

    public boolean isEmpty(Class<?> clazz) {
        Cursor cursor = this.mDatabase.rawQuery("SELECT 1 FROM " + DBManager.getTableName(clazz) + " LIMIT 1", null);
        if (cursor == null) {
            return true;
        }
        int size = cursor.getCount();
        cursor.close();
        return size <= 0;
    }

    public int getCount(Class<?> clazz) {
        Cursor cursor = this.mDatabase.rawQuery("SELECT COUNT(1) FROM " + DBManager.getTableName(clazz), null);
        if (cursor == null) {
            return 0;
        }
        int i = 0;
        if (0 != cursor.getCount()) {
            cursor.moveToFirst();
            i = cursor.getInt(0);
        }
        cursor.close();
        return i;
    }

    public void beginTransaction() {
        if (this.isBeginTransaction) {
            return;
        }
        this.mDatabase.beginTransaction();
        this.isBeginTransaction = true;
    }

    public void endTransaction() {
        if (this.isBeginTransaction) {
            this.mDatabase.endTransaction();
        }
        this.isBeginTransaction = false;
    }

    public void setTransactionSuccessful() {
        if (this.isBeginTransaction && this.mDatabase != null && this.mDatabase.inTransaction()) {
            this.mDatabase.setTransactionSuccessful();
        } else {
            this.isBeginTransaction = false;
        }
    }

    public void execSQL(String sql) {
        this.mDatabase.execSQL(sql);
    }

    public Cursor rawQuery(String sql, String[] selectArgs) {
        return this.mDatabase.rawQuery(sql, selectArgs);
    }

    public static final <T> List<T> reflectObject(Class<T> clazz, Cursor cursor) {
        ArrayList<T> list = new ArrayList<T>();
        Field[] fields = clazz.getDeclaredFields();
        while (cursor.moveToNext()) {
            T t = DBManager.buildObject(clazz, cursor, fields);
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public static final <T> T buildObject(Class<T> clazz, Cursor cursor, Field[] fields) {
        T t;
        try {
            t = clazz.newInstance();
        }
        catch (Exception e) {
            Logger.e((Object)e);
            return null;
        }
        if (fields == null) {
            fields = clazz.getDeclaredFields();
        }
        block15: for (Field field : fields) {
            String v;
            int index;
            Column column = field.getAnnotation(Column.class);
            if (column == null || (index = cursor.getColumnIndex(column.value())) == -1) continue;
            if (!TextUtils.isEmpty((CharSequence)column.set())) {
                try {
                    switch (column.type()) {
                        case TEXT: {
                            Method method = clazz.getMethod(column.set(), String.class);
                            method.invoke(t, cursor.getString(index));
                            break;
                        }
                        case INT: {
                            Method method = clazz.getMethod(column.set(), Integer.TYPE);
                            method.invoke(t, cursor.getInt(index));
                            break;
                        }
                        case DOUBLE: {
                            Method method = clazz.getMethod(column.set(), Double.TYPE);
                            method.invoke(t, cursor.getDouble(index));
                            break;
                        }
                        case FLOAT: {
                            Method method = clazz.getMethod(column.set(), Float.TYPE);
                            method.invoke(t, Float.valueOf(cursor.getFloat(index)));
                            break;
                        }
                        case BOOLEAN: {
                            Method method = clazz.getMethod(column.set(), Boolean.TYPE);
                            v = cursor.getString(index);
                            method.invoke(t, "1".equals(v) ? true : Boolean.parseBoolean(v));
                            break;
                        }
                        case CHAR: {
                            Method method = clazz.getMethod(column.set(), Character.TYPE);
                            method.invoke(t, Character.valueOf(cursor.getString(index).charAt(0)));
                            break;
                        }
                        case LONG: {
                            Method method = clazz.getMethod(column.set(), Long.TYPE);
                            method.invoke(t, cursor.getLong(index));
                            break;
                        }
                        default: {
                            throw new DatabaseException("This Field not set type.");
                        }
                    }
                }
                catch (Exception e) {
                    Logger.w((Object)field);
                    Logger.e((Object)e);
                }
                continue;
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            try {
                ?[] tt;
                if (type == Integer.TYPE) {
                    field.setInt(t, cursor.getInt(index));
                    continue;
                }
                if (type == Integer.class) {
                    field.set(t, cursor.getInt(index));
                    continue;
                }
                if (type == Long.TYPE) {
                    field.setLong(t, cursor.getLong(index));
                    continue;
                }
                if (type == Long.class) {
                    field.set(t, cursor.getLong(index));
                    continue;
                }
                if (type == String.class) {
                    field.set(t, cursor.getString(index));
                    continue;
                }
                if (type == Character.TYPE) {
                    field.setChar(t, cursor.getString(index).charAt(0));
                    continue;
                }
                if (type == Character.class) {
                    field.set(t, Character.valueOf(cursor.getString(index).charAt(0)));
                    continue;
                }
                if (type == Double.TYPE) {
                    field.setDouble(t, cursor.getDouble(index));
                    continue;
                }
                if (type == Double.class) {
                    field.set(t, cursor.getDouble(index));
                    continue;
                }
                if (type == Boolean.TYPE || type == Boolean.class) {
                    v = cursor.getString(index);
                    field.setBoolean(t, "1".equals(v) ? true : Boolean.parseBoolean(v));
                    continue;
                }
                if (type == Float.TYPE) {
                    field.setFloat(t, cursor.getFloat(index));
                    continue;
                }
                if (type == Float.class) {
                    field.set(t, Float.valueOf(cursor.getFloat(index)));
                    continue;
                }
                if (type == Short.TYPE) {
                    field.setShort(t, cursor.getShort(index));
                    continue;
                }
                if (type == Short.class) {
                    field.set(t, cursor.getShort(index));
                    continue;
                }
                if (type == Byte.TYPE) {
                    field.setByte(t, (byte)cursor.getInt(index));
                    continue;
                }
                if (type == Byte.class) {
                    field.set(t, (byte)cursor.getInt(index));
                    continue;
                }
                if (!type.isEnum()) continue;
                String s = cursor.getString(index);
                for (Object oo : tt = type.getEnumConstants()) {
                    if (!s.equals(oo.toString())) continue;
                    field.set(t, oo);
                    continue block15;
                }
            }
            catch (Exception e) {
                Logger.w((Object)field);
                Logger.e((Object)e);
            }
        }
        return t;
    }

    private static final DBType getDBType(Column column, Class<?> type) {
        if (column.type() != DBType.NONE) {
            return column.type();
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return DBType.INT;
        }
        if (Double.TYPE == type || Double.class == type) {
            return DBType.DOUBLE;
        }
        if (Character.TYPE == type || Character.class == type) {
            return DBType.CHAR;
        }
        if (Long.TYPE == type || Long.class == type) {
            return DBType.LONG;
        }
        if (Short.TYPE == type || Short.class == type) {
            return DBType.INT;
        }
        if (Float.TYPE == type || Float.class == type) {
            return DBType.FLOAT;
        }
        if (Boolean.TYPE == type || Boolean.class == type) {
            return DBType.BOOLEAN;
        }
        if (Byte.TYPE == type || Byte.class == type) {
            return DBType.INT;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return DBType.TEXT;
        }
        if (type.isEnum()) {
            return DBType.TEXT;
        }
        throw new DatabaseException(type + " no support to mapping.");
    }

    private static final <T> void setObjectValue(Field field, T t, Object value) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type == Integer.TYPE) {
                field.setInt(t, Integer.parseInt(value.toString()));
            } else if (type == Long.TYPE) {
                field.setLong(t, Long.parseLong(value.toString()));
            } else if (type == String.class) {
                field.set(t, value);
            } else if (type == Character.TYPE) {
                field.setChar(t, ((Character)value).charValue());
            } else if (type == Double.TYPE) {
                field.setDouble(t, (Double)value);
            } else if (type == Boolean.TYPE) {
                field.setBoolean(t, (Boolean)value);
            } else if (type == Float.TYPE) {
                field.setFloat(t, ((Float)value).floatValue());
            } else if (type == Short.TYPE) {
                field.setShort(t, (Short)value);
            } else if (type == Byte.TYPE) {
                field.setByte(t, (Byte)value);
            } else {
                field.set(t, value);
            }
        }
        catch (Exception e) {
            Logger.w((Object)field);
            Logger.e((Object)e);
        }
    }

    private static final <T> String getFieldValue(Class<?> clazz, Column column, Field field, T t) {
        if (!TextUtils.isEmpty((CharSequence)column.get())) {
            try {
                Method method = clazz.getMethod(column.get(), new Class[0]);
                Object obj = method.invoke(t, new Object[0]);
                if (obj == null) {
                    return null;
                }
                return obj.toString();
            }
            catch (Exception e) {
                Logger.e((Object)e);
                return null;
            }
        }
        field.setAccessible(true);
        try {
            Object obj = field.get(t);
            return obj == null ? "" : obj.toString();
        }
        catch (IllegalAccessException e1) {
            Logger.e((Object)e1);
        }
        catch (IllegalArgumentException e1) {
            Logger.e((Object)e1);
        }
        return null;
    }

    private static final Table getTable(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new DatabaseException("Class " + clazz + " not have Table Annotation!");
        }
        return table;
    }

    private static final <T> void checkClass(T t, Class<?> clazz) {
        if (!clazz.isInstance(t)) {
            throw new DatabaseException("Class - Type mismatch.");
        }
    }

    public static final String getTableName(Class<?> clazz) {
        return DBManager.getTable(clazz).value();
    }

    private static final boolean isIgnoreColumn(String[] columns, Column column) {
        if (columns == null) {
            return false;
        }
        for (String s : columns) {
            if (!s.equals(column.value())) continue;
            return true;
        }
        return false;
    }

    private Column getPrimaryColumn(Class<?> clazz, boolean throwError) {
        for (Field field : clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !column.isPrimary()) continue;
            return column;
        }
        if (throwError) {
            throw new DatabaseException("This table no primary key.");
        }
        return null;
    }
}

