/*
 * Decompiled with CFR 0.152.
 */
package com.jacky.log;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;

public final class Logger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final String ClassName = Logger.class.getName();
    private static int LEVEL = 2;
    private static String TAG = "Logger";

    public static void setLogLevel(int level) {
        LEVEL = level;
    }

    public static void setTag(String tag) {
        TAG = tag;
    }

    public static <T> void v(T msg) {
        Logger.printLog(2, msg);
    }

    public static <T> void d(T msg) {
        Logger.printLog(3, msg);
    }

    public static <T> void i(T msg) {
        Logger.printLog(4, msg);
    }

    public static <T> void w(T msg) {
        Logger.printLog(5, msg);
    }

    public static <T> void e(T msg) {
        Logger.printLog(6, msg);
    }

    public static void v(Object ... msg) {
        Logger.printLog(2, msg);
    }

    public static void d(Object ... msg) {
        Logger.printLog(3, msg);
    }

    public static void i(Object ... msg) {
        Logger.printLog(4, msg);
    }

    public static void w(Object ... msg) {
        Logger.printLog(5, msg);
    }

    public static void e(Object ... msg) {
        Logger.printLog(6, msg);
    }

    private static void printLog(int p, Object ... msg) {
        if (!Logger.isLoggable(p)) {
            return;
        }
        if (msg == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] statck = Thread.currentThread().getStackTrace();
        if (statck != null) {
            boolean isOk = false;
            StackTraceElement[] stackTraceElementArray = statck;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element = stackTraceElementArray[i];
                if (ClassName.equals(element.getClassName())) {
                    isOk = true;
                    continue;
                }
                if (!isOk) continue;
                sb.append('[').append(element.getClassName()).append(':').append(':').append(element.getMethodName()).append('(').append(element.getLineNumber()).append(')').append(']');
                break;
            }
        }
        for (Object obj : msg) {
            if (obj == null) continue;
            sb.append(" ");
            if (obj instanceof Throwable) {
                sb.append(Logger.getStackTraceString((Throwable)obj));
                continue;
            }
            if (obj.getClass().isArray()) {
                int size = Array.getLength(obj);
                sb.append('[');
                for (int i = 0; i < size; ++i) {
                    sb.append(Array.get(obj, i)).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(']');
                continue;
            }
            sb.append(obj);
        }
        Logger.showLongString(p, TAG, sb);
    }

    private static boolean isLoggable(int level) {
        return level >= LEVEL;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static void longV(String tag, CharSequence sequence) {
        Logger.showLongString(2, tag, sequence);
    }

    public static void longD(String tag, CharSequence sequence) {
        Logger.showLongString(3, tag, sequence);
    }

    public static void longI(String tag, CharSequence sequence) {
        Logger.showLongString(4, tag, sequence);
    }

    public static void longW(String tag, CharSequence sequence) {
        Logger.showLongString(5, tag, sequence);
    }

    public static void longE(String tag, CharSequence sequence) {
        Logger.showLongString(6, tag, sequence);
    }

    public static void showLongString(int p, String tag, CharSequence sequence) {
        block3: {
            if (!Logger.isLoggable(p)) {
                return;
            }
            String string = sequence.toString();
            int i = 0;
            int size = string.length();
            while (true) {
                if (i > 0) {
                    tag = null;
                }
                if (size < 3000) break;
                Log.println((int)p, (String)tag, (String)string.substring(i, i + 3000));
                size -= 3000;
                i += 3000;
            }
            if (size <= 0) break block3;
            Log.println((int)p, (String)tag, (String)string.substring(i, i + size));
        }
    }
}

