/*
 * Decompiled with CFR 0.152.
 */
package com.jacksen.sharelibrary.wx;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.jacksen.sharelibrary.BaseShareHandler;
import com.jacksen.sharelibrary.PlatformConfigHelper;
import com.jacksen.sharelibrary.R;
import com.jacksen.sharelibrary.ShareListener;
import com.jacksen.sharelibrary.exception.ConfigErrorException;
import com.jacksen.sharelibrary.exception.InvalidParamException;
import com.jacksen.sharelibrary.exception.ShareException;
import com.jacksen.sharelibrary.exception.UnsupportedOperateException;
import com.jacksen.sharelibrary.util.BitmapUtil;
import com.jacksen.sharelibrary.wx.param.ShareImageParam;
import com.jacksen.sharelibrary.wx.param.ShareMusicParam;
import com.jacksen.sharelibrary.wx.param.ShareTextParam;
import com.jacksen.sharelibrary.wx.param.ShareVideoParam;
import com.jacksen.sharelibrary.wx.param.ShareWebPageParam;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import com.tencent.mm.sdk.modelmsg.WXTextObject;
import com.tencent.mm.sdk.modelmsg.WXWebpageObject;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.WXAPIFactory;

public abstract class BaseWXShareHandler
extends BaseShareHandler {
    private String appId;
    private IWXAPI iwxapi;
    private BroadcastReceiver shareResultReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ShareListener shareListener = BaseWXShareHandler.this.getShareListener();
            if (intent == null || shareListener == null) {
                return;
            }
            int statusCode = intent.getIntExtra("status_code", -1);
            switch (statusCode) {
                case 100: {
                    shareListener.onSuccess();
                    break;
                }
                case 101: {
                    shareListener.onCancel();
                    break;
                }
                case 102: {
                    shareListener.onError("");
                }
            }
        }
    };

    public BaseWXShareHandler(Context context) {
        super(context);
    }

    @Override
    protected void checkConfig() throws Exception {
        this.appId = PlatformConfigHelper.getAppId();
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            throw new ConfigErrorException(this.context.getString(R.string.error_wx_app_id_invalid));
        }
    }

    @Override
    protected void initShare() throws ShareException {
        this.iwxapi = WXAPIFactory.createWXAPI((Context)this.context, (String)this.appId, (boolean)true);
        if (!this.iwxapi.isWXAppInstalled()) {
            this.getShareListener().onError(this.context.getString(R.string.error_wx_no_platform));
            throw new ConfigErrorException(this.context.getString(R.string.error_wx_no_platform), 1021);
        }
        this.iwxapi.registerApp(this.appId);
    }

    @Override
    protected void checkPlatform() throws ShareException {
        int wxVersion;
        if (1 == this.getShareType() && (wxVersion = this.iwxapi.getWXAppSupportAPI()) < 0x21020001) {
            this.getShareListener().onError(this.context.getString(R.string.error_wx_unsupported_version));
            throw new UnsupportedOperateException(this.context.getString(R.string.error_wx_unsupported_version));
        }
    }

    @Override
    protected void shareText(ShareTextParam textParam) throws ShareException {
        WXTextObject textObject = new WXTextObject();
        textObject.text = textParam.getContent();
        if (textObject.checkArgs()) {
            throw new InvalidParamException(this.context.getString(R.string.error_wx_param_text_invalid));
        }
        WXMediaMessage textMsg = new WXMediaMessage();
        textMsg.mediaObject = textObject;
        textMsg.description = textParam.getContent();
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction();
        req.message = textMsg;
        req.scene = this.getShareType();
        boolean result = this.iwxapi.sendReq((BaseReq)req);
        this.judgeShareResult(result);
    }

    @Override
    protected void shareImage(ShareImageParam imageParam) throws ShareException {
    }

    @Override
    protected void shareMusic(ShareMusicParam musicParam) throws ShareException {
    }

    @Override
    protected void shareVideo(ShareVideoParam videoParam) throws ShareException {
    }

    @Override
    protected void shareWebPage(ShareWebPageParam webPageParam) throws ShareException {
        if (TextUtils.isEmpty((CharSequence)webPageParam.getTargetUrl())) {
            throw new InvalidParamException(this.context.getString(R.string.error_wx_param_url_invalid));
        }
        WXWebpageObject webpageObject = new WXWebpageObject();
        webpageObject.webpageUrl = webPageParam.getTargetUrl();
        WXMediaMessage message = new WXMediaMessage((WXMediaMessage.IMediaObject)webpageObject);
        message.title = webPageParam.getTitle();
        message.description = webPageParam.getDescription();
        message.thumbData = BitmapUtil.bitmapToByteArray(webPageParam.getThumbBitmap());
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.message = message;
        req.transaction = this.buildTransaction();
        req.scene = this.getShareType();
        boolean result = this.iwxapi.sendReq((BaseReq)req);
        this.judgeShareResult(result);
    }

    private void judgeShareResult(boolean result) throws ShareException {
        if (!result) {
            this.getShareListener().onError(this.context.getString(R.string.error_wx_share_failure));
            throw new ShareException(this.context.getString(R.string.error_wx_share_failure));
        }
    }

    @Override
    public void release() {
        if (this.context != null) {
            this.context.unregisterReceiver(this.shareResultReceiver);
        }
        super.release();
    }

    protected abstract int getShareType();

    public void onReq(BaseReq baseReq) {
    }

    public void onResp(BaseResp baseResp) {
        ShareListener shareListener = this.getShareListener();
        if (shareListener == null) {
            return;
        }
        switch (baseResp.errCode) {
            case 0: {
                shareListener.onSuccess();
                break;
            }
            case -2: {
                shareListener.onCancel();
                break;
            }
            case -3: {
                shareListener.onError(baseResp.errStr);
            }
        }
    }
}

