/*
 * Decompiled with CFR 0.152.
 */
package com.jacksen.sharelibrary.core;

import android.content.Context;
import com.jacksen.sharelibrary.BaseShareHandler;
import com.jacksen.sharelibrary.anno.PlatformScope;
import com.jacksen.sharelibrary.core.DefaultShareHandler;
import com.jacksen.sharelibrary.wx.WxChatShareHandler;
import com.jacksen.sharelibrary.wx.WxMomentShareHandler;

public class ShareHandlerPool {
    private static ShareHandlerPool handlerPool = new ShareHandlerPool();
    private BaseShareHandler shareHandler;

    private ShareHandlerPool() {
    }

    public static BaseShareHandler newHandler(Context context, @PlatformScope String platform) {
        BaseShareHandler handler = null;
        switch (platform) {
            case "wx_session": {
                handler = new WxChatShareHandler(context);
                break;
            }
            case "wx_moment": {
                handler = new WxMomentShareHandler(context);
                break;
            }
            default: {
                handler = new DefaultShareHandler(context);
            }
        }
        ShareHandlerPool.handlerPool.shareHandler = handler;
        return handler;
    }

    public static BaseShareHandler getCurrentHandler() {
        return ShareHandlerPool.handlerPool.shareHandler;
    }
}

