/*
 * Decompiled with CFR 0.152.
 */
package com.jacksen.sharelibrary.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.jacksen.sharelibrary.core.ShareHandlerPool;
import com.jacksen.sharelibrary.wx.BaseWXShareHandler;
import com.jacksen.sharelibrary.wx.WxChatShareHandler;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.WXAPIFactory;

public abstract class BaseWXEntryActivity
extends Activity
implements IWXAPIEventHandler {
    private IWXAPI iwxapi;
    private BaseWXShareHandler shareHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.shareHandler = (BaseWXShareHandler)ShareHandlerPool.getCurrentHandler();
        if (this.shareHandler == null) {
            this.shareHandler = new WxChatShareHandler((Context)this);
        }
        if (this.iwxapi == null) {
            this.iwxapi = WXAPIFactory.createWXAPI((Context)this, (String)this.getAppId(), (boolean)false);
            if (this.iwxapi.isWXAppInstalled()) {
                this.iwxapi.registerApp(this.getAppId());
            }
            this.iwxapi.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        if (this.iwxapi != null) {
            this.iwxapi.handleIntent(intent, (IWXAPIEventHandler)this);
        }
    }

    public void onReq(BaseReq baseReq) {
    }

    public void onResp(BaseResp baseResp) {
        this.shareHandler.onResp(baseResp);
        this.finish();
    }

    protected void release() {
        if (this.shareHandler != null) {
            this.shareHandler.release();
        }
    }

    protected abstract String getAppId();
}

