/*
 * Decompiled with CFR 0.152.
 */
package com.jacksen.sharelibrary;

import android.content.Context;
import com.jacksen.sharelibrary.ShareListener;
import com.jacksen.sharelibrary.exception.ShareException;
import com.jacksen.sharelibrary.wx.param.BaseShareParam;
import com.jacksen.sharelibrary.wx.param.ShareImageParam;
import com.jacksen.sharelibrary.wx.param.ShareMusicParam;
import com.jacksen.sharelibrary.wx.param.ShareTextParam;
import com.jacksen.sharelibrary.wx.param.ShareVideoParam;
import com.jacksen.sharelibrary.wx.param.ShareWebPageParam;

public abstract class BaseShareHandler {
    protected Context context;
    private ShareListener shareListener;

    public BaseShareHandler(Context context) {
        this.context = context;
        try {
            this.checkConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void share(BaseShareParam shareParam, ShareListener shareListener) throws ShareException {
        this.shareListener = shareListener;
        this.initShare();
        this.checkPlatform();
        if (shareParam instanceof ShareTextParam) {
            this.shareText((ShareTextParam)shareParam);
        } else if (shareParam instanceof ShareImageParam) {
            this.shareImage((ShareImageParam)shareParam);
        } else if (shareParam instanceof ShareMusicParam) {
            this.shareMusic((ShareMusicParam)shareParam);
        } else if (shareParam instanceof ShareVideoParam) {
            this.shareVideo((ShareVideoParam)shareParam);
        } else if (shareParam instanceof ShareWebPageParam) {
            this.shareWebPage((ShareWebPageParam)shareParam);
        }
    }

    protected String buildTransaction() {
        return String.valueOf(System.currentTimeMillis());
    }

    public ShareListener getShareListener() {
        return this.shareListener;
    }

    public void release() {
        this.context = null;
        this.shareListener = null;
    }

    protected abstract void checkConfig() throws Exception;

    protected abstract void initShare() throws ShareException;

    protected abstract void checkPlatform() throws ShareException;

    protected abstract void shareText(ShareTextParam var1) throws ShareException;

    protected abstract void shareImage(ShareImageParam var1) throws ShareException;

    protected abstract void shareMusic(ShareMusicParam var1) throws ShareException;

    protected abstract void shareVideo(ShareVideoParam var1) throws ShareException;

    protected abstract void shareWebPage(ShareWebPageParam var1) throws ShareException;
}

