/*
 * Decompiled with CFR 0.152.
 */
package com.jackpocket.spinwheelview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.jackpocket.spinwheelview.SpinnerTask;

public class SpinWheelView
extends ImageView
implements SpinnerTask.SpinTaskCallbacks,
View.OnTouchListener {
    public static final float MIN_FORCE = 0.0f;
    public static final float MAX_FORCE = 3.0f;
    private static final float FORCE_ADJUSTMENT = 2.0f;
    private float currentRotationDegrees = 0.0f;
    private SpinnerTask spinnerTask;
    private boolean running = false;
    private Runnable spinCompletionListener;
    private boolean spinWithTouchEnabled = false;
    private float[] startingTouchPos = new float[]{0.0f, 0.0f};
    private float[] currentTouchPos = new float[]{0.0f, 0.0f};
    private float[] lastTouchPos = new float[]{0.0f, 0.0f};
    private Runnable preFlingCallback;
    private int flingMaxDistance;
    private float flingTargetDegrees = 0.0f;
    private int[] viewCenterPos;

    public SpinWheelView(Context context) {
        super(context);
        this.init();
    }

    public SpinWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SpinWheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
        this.setOnTouchListener(this);
        this.flingMaxDistance = this.getPxFromDip(25);
    }

    public SpinWheelView setSpinCompletionListener(Runnable spinCompletionListener) {
        this.spinCompletionListener = spinCompletionListener;
        return this;
    }

    public SpinWheelView setSpinWithTouchEnabled(boolean spinWithTouchEnabled) {
        this.spinWithTouchEnabled = spinWithTouchEnabled;
        return this;
    }

    public SpinWheelView setTargetDegreesOnFling(float flingTargetDegrees) {
        this.flingTargetDegrees = flingTargetDegrees % 360.0f;
        return this;
    }

    public SpinWheelView setPreFlingCallback(Runnable preFlingCallback) {
        this.preFlingCallback = preFlingCallback;
        return this;
    }

    public void spinTo(float targetRotationDegrees) {
        this.spinTo(targetRotationDegrees, 1.5f);
    }

    public void spinTo(float targetRotationDegrees, float force) {
        this.spinTo(targetRotationDegrees, force, true);
    }

    public void spinTo(float targetRotationDegrees, float force, boolean clockwise) {
        if (this.running) {
            return;
        }
        this.stop();
        force = Math.min(force, 3.0f);
        force = Math.max(force, 0.0f);
        this.spinnerTask = new SpinnerTask(this.currentRotationDegrees, targetRotationDegrees % 360.0f, (force += 2.0f) * (float)(clockwise ? 1 : -1), this);
        this.running = true;
        new Thread(this.spinnerTask).start();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.running || !this.spinWithTouchEnabled) {
            return false;
        }
        if (event.getAction() == 0) {
            this.onActionDown(event);
            return true;
        }
        if (event.getAction() == 2) {
            this.onActionMove(event);
        } else if (event.getAction() == 1) {
            this.onActionUp(event);
        }
        return false;
    }

    private void onActionDown(MotionEvent event) {
        this.startingTouchPos = new float[]{event.getRawX(), event.getRawY()};
        this.currentTouchPos = this.startingTouchPos;
        this.lastTouchPos = this.currentTouchPos;
        this.adjustAngleOnTouch();
    }

    private void onActionMove(MotionEvent event) {
        this.lastTouchPos = this.currentTouchPos;
        this.currentTouchPos = new float[]{event.getRawX(), event.getRawY()};
        this.adjustAngleOnTouch();
    }

    private void onActionUp(MotionEvent event) {
        boolean clockwise;
        boolean isLeft;
        this.lastTouchPos = this.currentTouchPos;
        this.currentTouchPos = new float[]{event.getRawX(), event.getRawY()};
        double totalDistance = Math.sqrt(Math.pow(this.currentTouchPos[0] - this.startingTouchPos[0], 2.0) + Math.pow(this.currentTouchPos[1] - this.startingTouchPos[1], 2.0));
        if (totalDistance < (double)(this.flingMaxDistance * 2)) {
            this.adjustAngleOnTouch();
            return;
        }
        double distance = Math.sqrt(Math.pow(this.currentTouchPos[0] - this.lastTouchPos[0], 2.0) + Math.pow(this.currentTouchPos[1] - this.lastTouchPos[1], 2.0));
        float force = (float)(distance / (double)this.flingMaxDistance * 3.0);
        float mX = this.currentTouchPos[0] - this.startingTouchPos[0];
        float mY = this.currentTouchPos[1] - this.startingTouchPos[1];
        boolean bl = isLeft = this.calculateCrossProduct(this.currentTouchPos, this.startingTouchPos, this.viewCenterPos) < 0.0f;
        if (isLeft) {
            clockwise = !(mX < 0.0f && mY < 0.0f || 0.0f < mX && mY < 0.0f);
        } else {
            boolean bl2 = clockwise = !(mX < 0.0f && 0.0f < mY || 0.0f < mX && 0.0f < mY);
        }
        if (this.preFlingCallback != null) {
            this.preFlingCallback.run();
        }
        this.spinTo(this.flingTargetDegrees, force, clockwise);
    }

    public float calculateCrossProduct(float[] a, float[] b, int[] center) {
        if (a[1] < b[1]) {
            float[] temp = a;
            a = b;
            b = temp;
        }
        return (b[0] - a[0]) * ((float)center[1] - a[1]) - (b[1] - a[1]) * ((float)center[0] - a[0]);
    }

    private void adjustAngleOnTouch() {
        if (this.viewCenterPos == null) {
            int[] locationInWindow = new int[2];
            this.getLocationInWindow(locationInWindow);
            this.viewCenterPos = new int[]{locationInWindow[0] + this.getWidth() / 2, locationInWindow[1] + this.getHeight() / 2};
        }
        this.currentRotationDegrees = 180.0f - (float)Math.toDegrees(Math.atan2(this.currentTouchPos[0] - (float)this.viewCenterPos[0], this.currentTouchPos[1] - (float)this.viewCenterPos[1]));
        this.invalidate();
    }

    @Override
    public void update(final float currentRotationDegrees) {
        this.post(new Runnable(){

            @Override
            public void run() {
                SpinWheelView.this.currentRotationDegrees = currentRotationDegrees % 360.0f;
                SpinWheelView.this.invalidate();
            }
        });
    }

    @Override
    public void onSpinComplete() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (SpinWheelView.this.spinCompletionListener != null) {
                    SpinWheelView.this.spinCompletionListener.run();
                }
            }
        });
        this.stop();
    }

    public void onDraw(Canvas canvas) {
        canvas.save();
        canvas.rotate(this.currentRotationDegrees, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
        super.onDraw(canvas);
        canvas.restore();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stop();
    }

    private void stop() {
        this.running = false;
        try {
            if (this.spinnerTask != null) {
                this.spinnerTask.cancel();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getPxFromDip(int dip) {
        return (int)((float)dip * this.getResources().getDisplayMetrics().density + 0.5f);
    }
}

