/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.paletteshadowview;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v7.graphics.Palette;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.jackandphantom.paletteshadowview.R;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class PaletteShadowView
extends AppCompatImageView {
    private Paint paint = new Paint();
    private Bitmap mBitmap;
    private Bitmap realBitmap;
    private int minimumWidth = 400;
    private Paint shadowPaint = new Paint();
    private RectF shadowRect;
    private int DEFAULT_PADDING = 40;
    private Palette mPalette;
    private int shadowColor = -1;
    private AsyncTask mAsyncTask;
    private static final int DEFAULT_OFFSET = 5;
    private static final int DEFAULT_SHADOW_RADIUS = 20;
    private int shadowRadius;
    private static final int MSG = 257;
    private int offsetX;
    private int offsetY;
    private ShadowHandler mShadowHandler;
    private int roundedRadius = 0;
    private Drawable initialDrawable;
    Palette.PaletteAsyncListener paletteAsyncListener = new Palette.PaletteAsyncListener(){

        public void onGenerated(@Nullable Palette palette) {
            if (palette != null) {
                PaletteShadowView.this.mPalette = palette;
                if (PaletteShadowView.this.mPalette.getDominantSwatch() != null) {
                    PaletteShadowView.this.shadowColor = PaletteShadowView.this.mPalette.getDominantSwatch().getRgb();
                    PaletteShadowView.this.mShadowHandler.sendEmptyMessage(257);
                }
            }
        }
    };

    public PaletteShadowView(Context context) {
        super(context);
    }

    public PaletteShadowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PaletteShadowView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PaletteShadowView);
        this.initialDrawable = a.getDrawable(R.styleable.PaletteShadowView_paletteSrc);
        this.shadowRadius = a.getInt(R.styleable.PaletteShadowView_paletteShadowRadius, this.shadowRadius);
        this.shadowColor = a.getColor(R.styleable.PaletteShadowView_paletteShadowColor, -1);
        this.offsetX = a.getInt(R.styleable.PaletteShadowView_paletteOffsetX, 5);
        this.offsetY = a.getInt(R.styleable.PaletteShadowView_paletteOffsetY, 5);
        this.roundedRadius = a.getInt(R.styleable.PaletteShadowView_paletteRoundRadius, 0);
        a.recycle();
        this.init();
    }

    private void init() {
        this.paint.setAntiAlias(true);
        this.paint.setDither(true);
        this.setLayerType(1, null);
        this.shadowPaint.setAntiAlias(true);
        this.shadowPaint.setDither(true);
        this.shadowPaint.setShadowLayer((float)this.shadowRadius, 5.0f, 5.0f, -3355444);
        this.mShadowHandler = new ShadowHandler(this);
        if (this.initialDrawable != null) {
            this.getDrawableToBitmap(this.initialDrawable);
            if (this.shadowColor != -1) {
                this.mShadowHandler.sendEmptyMessage(257);
            } else {
                this.initShadowColor(this.mBitmap);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = this.minimumWidth + this.getPaddingLeft() + this.getPaddingRight();
        int desiredHeight = this.minimumWidth + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(this.measureDimension(desiredWidth, widthMeasureSpec), this.measureDimension(desiredHeight, heightMeasureSpec));
    }

    private int measureDimension(int desiredSize, int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else if (specMode == 0) {
            if (this.realBitmap != null) {
                result = specSize;
            }
        } else {
            result = desiredSize;
            if (specMode == Integer.MIN_VALUE) {
                result = this.minimumWidth;
            }
        }
        if (result < desiredSize) {
            result = desiredSize;
        }
        return result;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.shadowRect = new RectF((float)this.DEFAULT_PADDING, (float)this.DEFAULT_PADDING, (float)(this.getWidth() - this.DEFAULT_PADDING), (float)(this.getHeight() - this.DEFAULT_PADDING));
        if (this.realBitmap == null && this.mBitmap != null) {
            this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
            this.initShadowColor(this.mBitmap);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.realBitmap != null) {
            canvas.drawRoundRect(this.shadowRect, (float)this.roundedRadius, (float)this.roundedRadius, this.shadowPaint);
            canvas.drawBitmap(this.realBitmap, 0.0f, 0.0f, null);
        }
        if (this.shadowColor != -1) {
            this.mAsyncTask.cancel(true);
        }
    }

    public void setImageResource(int resId) {
        try {
            this.mBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
            this.initShadowColor(this.mBitmap);
        }
        catch (NullPointerException exp) {
            exp.printStackTrace();
        }
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        try {
            this.getDrawableToBitmap(drawable);
            this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
            this.initShadowColor(this.mBitmap);
        }
        catch (NullPointerException exp) {
            exp.printStackTrace();
        }
    }

    public void setImageBitmap(Bitmap bm) {
        try {
            this.mBitmap = bm;
            this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
            this.initShadowColor(bm);
        }
        catch (NullPointerException exp) {
            exp.printStackTrace();
        }
    }

    public void setImageURI(@Nullable Uri uri) {
        try {
            this.mBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.getContext().getContentResolver(), (Uri)uri);
            this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
            this.initShadowColor(this.mBitmap);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void getDrawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable.draw(canvas);
        this.mBitmap = bitmap;
    }

    private Bitmap createRoundedBitmap(Bitmap bitmap, int radius) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return null;
        }
        Bitmap targetBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap smallBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(this.getWidth() - this.DEFAULT_PADDING * 2), (int)(this.getHeight() - this.DEFAULT_PADDING * 2), (boolean)false);
        Canvas canvas = new Canvas(targetBitmap);
        RectF rectF = new RectF((float)this.DEFAULT_PADDING, (float)this.DEFAULT_PADDING, (float)(this.getWidth() - this.DEFAULT_PADDING), (float)(this.getHeight() - this.DEFAULT_PADDING));
        canvas.drawRoundRect(rectF, (float)radius, (float)radius, this.paint);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(smallBitmap, (float)this.DEFAULT_PADDING, (float)this.DEFAULT_PADDING, this.paint);
        this.paint.setXfermode(null);
        return targetBitmap;
    }

    private void initShadowColor(Bitmap bitmap) {
        if (bitmap != null) {
            this.mAsyncTask = Palette.from((Bitmap)bitmap).generate(this.paletteAsyncListener);
        }
    }

    public void setShadowRadius(int radius) {
        this.shadowRadius = radius;
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setShadowColor(int color) {
        this.shadowColor = color;
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setShadowOffest(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public int getShadowRadius() {
        return this.shadowRadius;
    }

    public void setRoundedRadius(int radius) {
        if (this.mBitmap == null) {
            return;
        }
        this.roundedRadius = radius;
        this.realBitmap = this.createRoundedBitmap(this.mBitmap, this.roundedRadius);
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public int getRoundedRadius() {
        return this.roundedRadius;
    }

    public int[] getVibrantColor() {
        if (this.mPalette == null || this.mPalette.getVibrantSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getVibrantSwatch().getTitleTextColor(), this.mPalette.getVibrantSwatch().getBodyTextColor(), this.mPalette.getVibrantSwatch().getRgb()};
        return arry;
    }

    public int[] getDarkVibrantColor() {
        if (this.mPalette == null || this.mPalette.getDarkVibrantSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getDarkVibrantSwatch().getTitleTextColor(), this.mPalette.getDarkVibrantSwatch().getBodyTextColor(), this.mPalette.getDarkVibrantSwatch().getRgb()};
        return arry;
    }

    public int[] getLightVibrantColor() {
        if (this.mPalette == null || this.mPalette.getLightVibrantSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getLightVibrantSwatch().getTitleTextColor(), this.mPalette.getLightVibrantSwatch().getBodyTextColor(), this.mPalette.getLightVibrantSwatch().getRgb()};
        return arry;
    }

    public int[] getMutedColor() {
        if (this.mPalette == null || this.mPalette.getMutedSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getMutedSwatch().getTitleTextColor(), this.mPalette.getMutedSwatch().getBodyTextColor(), this.mPalette.getMutedSwatch().getRgb()};
        return arry;
    }

    public int[] getDarkMutedColor() {
        if (this.mPalette == null || this.mPalette.getDarkMutedSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getDarkMutedSwatch().getTitleTextColor(), this.mPalette.getDarkMutedSwatch().getBodyTextColor(), this.mPalette.getDarkMutedSwatch().getRgb()};
        return arry;
    }

    public int[] getLightMutedColor() {
        if (this.mPalette == null || this.mPalette.getLightMutedSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getLightMutedSwatch().getTitleTextColor(), this.mPalette.getLightMutedSwatch().getBodyTextColor(), this.mPalette.getLightMutedSwatch().getRgb()};
        return arry;
    }

    public int[] getDominantColor() {
        if (this.mPalette == null || this.mPalette.getDominantSwatch() == null) {
            return null;
        }
        int[] arry = new int[]{this.mPalette.getDominantSwatch().getTitleTextColor(), this.mPalette.getDominantSwatch().getBodyTextColor(), this.mPalette.getDominantSwatch().getRgb()};
        return arry;
    }

    public void setLightMutedColor() {
        if (this.mPalette == null || this.mPalette.getLightMutedSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getLightMutedSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setDarkMutedColor() {
        if (this.mPalette == null || this.mPalette.getDarkMutedSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getDarkMutedSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setMutedColor() {
        if (this.mPalette == null || this.mPalette.getMutedSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getMutedSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setLightVibrantColor() {
        if (this.mPalette == null || this.mPalette.getLightVibrantSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getLightVibrantSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setDarkVibrantColor() {
        if (this.mPalette == null || this.mPalette.getDarkVibrantSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getDarkVibrantSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setVibrantColor() {
        if (this.mPalette == null || this.mPalette.getMutedSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getMutedSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    public void setDominantColor() {
        if (this.mPalette == null || this.mPalette.getDominantSwatch() == null) {
            return;
        }
        this.shadowColor = this.mPalette.getDominantSwatch().getRgb();
        this.mShadowHandler.sendEmptyMessage(257);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mShadowHandler.removeCallbacksAndMessages(null);
    }

    private static class ShadowHandler
    extends Handler {
        private final WeakReference<PaletteShadowView> weakReference;

        private ShadowHandler(PaletteShadowView pletteImage) {
            this.weakReference = new WeakReference<PaletteShadowView>(pletteImage);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.weakReference.get() != null) {
                PaletteShadowView pletteImage = (PaletteShadowView)((Object)this.weakReference.get());
                if (pletteImage.offsetX < 5) {
                    pletteImage.offsetX = 5;
                }
                if (pletteImage.offsetY < 5) {
                    pletteImage.offsetY = 5;
                }
                if (pletteImage.shadowRadius < 20) {
                    pletteImage.shadowRadius = 20;
                }
                pletteImage.shadowPaint.setShadowLayer((float)pletteImage.shadowRadius, (float)pletteImage.offsetX, (float)pletteImage.offsetY, pletteImage.shadowColor);
                pletteImage.invalidate();
            }
        }
    }
}

