/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.androidlikebutton;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.jackandphantom.androidlikebutton.Utils;

public class AndroidDotView
extends View {
    private static final int DOTS_COUNT = 7;
    private static final int OUTER_DOTS_POSITION_ANGLE = 51;
    private int COLOR_1 = -16121;
    private int COLOR_2 = -26624;
    private float maxOuterDotsRadius;
    private float maxDotSize;
    private int centerX;
    private int centerY;
    private Paint[] circlePaint = new Paint[4];
    private float currentProgress = 0.0f;
    private float currentRadius = 0.0f;
    private float currentDotSize = 0.0f;
    private int width;
    private int height;
    private boolean isActive = true;
    private boolean changeDimension = false;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();

    public AndroidDotView(Context context) {
        super(context);
        this.init();
    }

    public AndroidDotView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AndroidDotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.circlePaint.length; ++i) {
            this.circlePaint[i] = new Paint();
            this.circlePaint[i].setStyle(Paint.Style.FILL);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (!this.changeDimension) {
            this.centerX = this.width / 2;
            this.centerY = this.height / 2;
            this.maxOuterDotsRadius = this.width / 2;
            this.maxDotSize = this.getDotSize(this.centerX) + 5;
        }
    }

    private int getDotSize(int width) {
        float c = (float)width / 100.0f;
        int value = (int)c;
        float result = c - (float)value;
        if ((double)result >= 0.5) {
            return value + 2;
        }
        return value;
    }

    protected void onDraw(Canvas canvas) {
        if (this.isActive) {
            this.drawOuterDotsFrame(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.changeDimension) {
            this.setMeasuredDimension(this.width, this.height);
        } else {
            this.width = AndroidDotView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
            this.height = AndroidDotView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
            this.setMeasuredDimension(this.width, this.height);
        }
    }

    private void drawOuterDotsFrame(Canvas canvas) {
        for (int i = 0; i < 7; ++i) {
            int cX = (int)((double)this.centerX + (double)this.currentRadius * Math.cos((double)(i * 51) * Math.PI / 180.0));
            int cY = (int)((double)this.centerY + (double)this.currentRadius * Math.sin((double)(i * 51) * Math.PI / 180.0));
            canvas.drawCircle((float)cX, (float)cY, this.currentDotSize, this.circlePaint[i % 4]);
        }
    }

    public void setCurrentProgress(float value) {
        this.currentProgress = value;
        this.currentRadius = this.maxOuterDotsRadius * value;
        this.currentDotSize = this.maxDotSize * value;
        this.updateDotsPaints();
        this.updateDotsAlpha();
        this.invalidate();
    }

    private void updateDotsPaints() {
        if (this.currentProgress < 0.5f) {
            float progress = this.currentProgress;
            this.circlePaint[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
            this.circlePaint[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_1)).intValue());
            this.circlePaint[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
            this.circlePaint[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_1)).intValue());
        } else {
            float progress = (float)Utils.mapValueFromRangeToRange(this.currentProgress, 0.5, 1.0, 0.0, 1.0);
            this.circlePaint[0].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_1)).intValue());
            this.circlePaint[1].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
            this.circlePaint[2].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_2, (Object)this.COLOR_1)).intValue());
            this.circlePaint[3].setColor(((Integer)this.argbEvaluator.evaluate(progress, (Object)this.COLOR_1, (Object)this.COLOR_2)).intValue());
        }
    }

    private void setViewAlpha() {
        int alpha;
        if (this.currentProgress < 0.8f) {
            float progress = (float)Utils.clamp(this.currentProgress, 0.9, 1.0);
            alpha = (int)(progress * 255.0f);
        } else {
            alpha = (int)((1.0f - this.currentProgress) * 255.0f);
        }
        for (int i = 0; i < this.circlePaint.length; ++i) {
            this.circlePaint[i].setAlpha(alpha);
        }
    }

    private void updateDotsAlpha() {
        float progress = (float)Utils.clamp(this.currentProgress, 0.6f, 1.0);
        int alpha = (int)Utils.mapValueFromRangeToRange(progress, 0.6f, 1.0, 255.0, 0.0);
        this.circlePaint[0].setAlpha(alpha);
        this.circlePaint[1].setAlpha(alpha);
        this.circlePaint[2].setAlpha(alpha);
        this.circlePaint[3].setAlpha(alpha);
    }

    void setWidthAndHeight(int width, int height) {
        if (width != 0 && height != 0) {
            this.centerX = width;
            this.width = width * 2;
            this.height = height * 2;
            this.centerY = height;
            this.maxOuterDotsRadius = width;
            this.maxDotSize = this.getDotSize(this.centerX) + 5;
            this.changeDimension = true;
            this.requestLayout();
        }
    }

    void setDotColor1(int color) {
        if (color != 0) {
            this.COLOR_1 = color;
        }
    }

    void setDotColor2(int color) {
        if (color != 0) {
            this.COLOR_2 = color;
        }
    }

    void setDotActive(boolean isActive) {
        this.isActive = isActive;
    }

    void setAllDotColor(int color1, int color2) {
        this.COLOR_1 = color1;
        this.COLOR_2 = color2;
    }
}

