/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.GeneratedKeyHolder;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedCreate<T, ID>
extends BaseMappedStatement<T, ID> {
    private final String queryNextSequenceStmt;
    private String dataClassName;

    private MappedCreate(TableInfo<T> tableInfo, String statement, List<FieldType> argFieldTypeList, String queryNextSequenceStmt) {
        super(tableInfo, statement, argFieldTypeList);
        this.dataClassName = tableInfo.getDataClass().getSimpleName();
        this.queryNextSequenceStmt = queryNextSequenceStmt;
    }

    @Override
    public int insert(DatabaseConnection databaseConnection, T data) throws SQLException {
        if (this.idField != null) {
            if (this.idField.isGeneratedIdSequence()) {
                this.assignSequenceId(databaseConnection, data);
            } else if (this.idField.isGeneratedId()) {
                return this.createWithGeneratedId(databaseConnection, data);
            }
        }
        return super.insert(databaseConnection, data);
    }

    public static <T, ID> MappedCreate<T, ID> build(DatabaseType databaseType, TableInfo<T> tableInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilder questionSb = new StringBuilder();
        ArrayList<FieldType> argFieldTypeList = new ArrayList<FieldType>();
        MappedCreate.appendTableName(databaseType, sb, "INSERT INTO ", tableInfo.getTableName());
        sb.append('(');
        boolean first = true;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!databaseType.isIdSequenceNeeded() && fieldType.isGeneratedId()) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",");
                questionSb.append(",");
            }
            MappedCreate.appendFieldColumnName(databaseType, sb, fieldType, argFieldTypeList);
            questionSb.append("?");
        }
        sb.append(") VALUES (").append((CharSequence)questionSb).append(")");
        FieldType idField = tableInfo.getIdField();
        String queryNext = MappedCreate.buildQueryNextSequence(databaseType, idField);
        return new MappedCreate<T, ID>(tableInfo, sb.toString(), argFieldTypeList, queryNext);
    }

    private static String buildQueryNextSequence(DatabaseType databaseType, FieldType idField) {
        if (idField == null) {
            return null;
        }
        String seqName = idField.getGeneratedIdSequence();
        if (seqName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        databaseType.appendSelectNextValFromSequence(sb, seqName);
        return sb.toString();
    }

    private void assignSequenceId(DatabaseConnection databaseConnection, T data) throws SQLException {
        long seqVal = databaseConnection.queryForLong(this.queryNextSequenceStmt);
        logger.debug("queried for sequence {} using stmt: {}", seqVal, this.queryNextSequenceStmt);
        if (seqVal == 0L) {
            throw new SQLException("Should not have returned 0 for stmt: " + this.queryNextSequenceStmt);
        }
        this.assignIdValue(data, seqVal, "sequence");
    }

    private int createWithGeneratedId(DatabaseConnection databaseConnection, T data) throws SQLException {
        Object[] args = this.getFieldObjects(data);
        try {
            KeyHolder keyHolder = new KeyHolder();
            int retVal = databaseConnection.insert(this.statement, args, this.argSqlTypes, keyHolder);
            logger.debug("create object using '{}' and {} args, changed {} rows", this.statement, args.length, retVal);
            if (args.length > 0) {
                logger.trace("create arguments: {}", new Object[]{args});
            }
            if (retVal == 1) {
                Number key = keyHolder.getKey();
                if (key == null) {
                    throw new SQLException("generated-id key was not set by the update call");
                }
                if (key.longValue() == 0L) {
                    throw new SQLException("generated-id key must not be 0 value");
                }
                this.assignIdValue(data, key, "keyholder");
            }
            return retVal;
        }
        catch (SQLException e) {
            logger.error("create object using '{}' and {} args, threw exception: {}", this.statement, args.length, e);
            if (args.length > 0) {
                logger.trace("create arguments: {}", new Object[]{args});
            }
            throw SqlExceptionUtil.create("Unable to run stmt on object " + data + ": " + this.statement, e);
        }
    }

    private void assignIdValue(T data, Number val, String label) throws SQLException {
        this.idField.assignIdValue(data, val);
        logger.debug("assigned id '{}' from {} to '{}' in {} object", val, label, this.idField.getFieldName(), this.dataClassName);
    }

    private class KeyHolder
    implements GeneratedKeyHolder {
        Number key;

        private KeyHolder() {
        }

        public Number getKey() {
            return this.key;
        }

        public void addKey(Number key) throws SQLException {
            if (this.key != null) {
                throw new SQLException("generated key has already been set to " + this.key + ", now set to " + key);
            }
            this.key = key;
        }
    }
}

