/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.Db2DatabaseType;
import com.j256.ormlite.db.DerbyClientServerDatabaseType;
import com.j256.ormlite.db.DerbyEmbeddedDatabaseType;
import com.j256.ormlite.db.H2DatabaseType;
import com.j256.ormlite.db.HsqldbDatabaseType;
import com.j256.ormlite.db.MysqlDatabaseType;
import com.j256.ormlite.db.OracleDatabaseType;
import com.j256.ormlite.db.PostgresDatabaseType;
import com.j256.ormlite.db.SqlServerDatabaseType;
import com.j256.ormlite.db.SqlServerJtdsDatabaseType;
import com.j256.ormlite.db.SqliteDatabaseType;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTypeUtils {
    private static List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();

    private DatabaseTypeUtils() {
    }

    public static DatabaseType createDatabaseType(String databaseUrl) {
        String dbTypePart = DatabaseTypeUtils.extractDbType(databaseUrl);
        for (DatabaseType databaseType : databaseTypes) {
            if (!databaseType.isDatabaseUrlThisType(databaseUrl, dbTypePart)) continue;
            return databaseType;
        }
        throw new IllegalArgumentException("Unknown database-type url part '" + dbTypePart + "' in: " + databaseUrl);
    }

    private static String extractDbType(String databaseUrl) {
        if (!databaseUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Database URL was expected to start with jdbc: but was " + databaseUrl);
        }
        String[] urlParts = databaseUrl.split(":");
        if (urlParts.length < 2) {
            throw new IllegalArgumentException("Database URL was expected to be in the form: jdbc:db-type:... but was " + databaseUrl);
        }
        return urlParts[1];
    }

    static {
        databaseTypes.add(new Db2DatabaseType());
        databaseTypes.add(new DerbyClientServerDatabaseType());
        databaseTypes.add(new DerbyEmbeddedDatabaseType());
        databaseTypes.add(new H2DatabaseType());
        databaseTypes.add(new HsqldbDatabaseType());
        databaseTypes.add(new MysqlDatabaseType());
        databaseTypes.add(new OracleDatabaseType());
        databaseTypes.add(new PostgresDatabaseType());
        databaseTypes.add(new SqliteDatabaseType());
        databaseTypes.add(new SqlServerDatabaseType());
        databaseTypes.add(new SqlServerJtdsDatabaseType());
    }
}

