/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseSqliteDatabaseType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;

public class SqliteDatabaseType
extends BaseSqliteDatabaseType {
    private static final String DATABASE_URL_PORTION = "sqlite";
    private static final String DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    private static final String DATABASE_NAME = "SQLite";
    private static final String XERIAL_DRIVER_CLASS = "org.ibex.nestedvm.Interpreter";
    private static final Logger logger = LoggerFactory.getLogger(SqliteDatabaseType.class);

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        try {
            Class.forName(XERIAL_DRIVER_CLASS);
        }
        catch (Exception e) {
            logger.error("WARNING: you seem to not be using the Xerial SQLite driver.  See ORMLite docs on SQLite: http://ormlite.com/docs/sqlite");
        }
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("LIMIT ");
        if (offset != null) {
            sb.append(offset).append(',');
        }
        sb.append(limit).append(' ');
    }

    public boolean isOffsetLimitArgument() {
        return true;
    }

    public boolean isNestedSavePointsSupported() {
        return false;
    }

    public void appendOffsetValue(StringBuilder sb, long offset) {
        throw new IllegalStateException("Offset is part of the LIMIT in database type " + ((Object)((Object)this)).getClass());
    }
}

