/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "postgresql";
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String DATABASE_NAME = "Postgres";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BYTEA");
    }

    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BYTEA");
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String sequenceName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, sequenceName);
        statementsBefore.add(seqSb.toString());
        sb.append("DEFAULT NEXTVAL(");
        sb.append('\'').append('\"').append(sequenceName).append('\"').append('\'');
        sb.append(") ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    public void appendEscapedEntityName(StringBuilder sb, String name) {
        boolean first = true;
        for (String namePart : name.split("\\.")) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append('\"').append(namePart).append('\"');
        }
    }

    public boolean isIdSequenceNeeded() {
        return true;
    }

    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT NEXTVAL(");
        this.appendEscapedWord(sb, sequenceName);
        sb.append(')');
    }

    public boolean isTruncateSupported() {
        return true;
    }

    public boolean isCreateIfNotExistsSupported() {
        int major = this.driver.getMajorVersion();
        if (major > 9 || major == 9 && this.driver.getMinorVersion() >= 1) {
            return true;
        }
        return super.isCreateIfNotExistsSupported();
    }
}

