/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.DatabaseTypeUtils;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcConnectionSource.class);
    private String url;
    private String username;
    private String password;
    private JdbcDatabaseConnection connection;
    private DatabaseType databaseType;
    protected boolean initialized = false;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.databaseType = databaseType;
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.url == null) {
            throw new SQLException("url was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.url);
        }
        this.databaseType.loadDriver();
        this.initialized = true;
    }

    public void close() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            this.connection.close();
            logger.debug("closed connection {}", this.connection);
            this.connection = null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        this.connection = this.makeConnection(logger);
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) {
        return true;
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
    }

    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.databaseType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    protected JdbcDatabaseConnection makeConnection(Logger logger) throws SQLException {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        JdbcDatabaseConnection connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        logger.debug("opened connection to {} got #{}", this.url, connection.hashCode());
        return connection;
    }
}

