/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.field.SqlType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TypeValMapper {
    private static final Map<SqlType, Integer[]> typeToValMap = new HashMap<SqlType, Integer[]>();

    public static int getTypeValForSqlType(SqlType sqlType) throws SQLException {
        Integer[] typeVals = typeToValMap.get(sqlType);
        if (typeVals.length == 0) {
            throw new SQLException("SqlType does not have any JDBC type value mapping: " + sqlType);
        }
        return typeVals[0];
    }

    static {
        block17: for (SqlType sqlType : SqlType.values()) {
            switch (sqlType) {
                case STRING: {
                    typeToValMap.put(sqlType, new Integer[]{12});
                    continue block17;
                }
                case LONG_STRING: {
                    typeToValMap.put(sqlType, new Integer[]{-1});
                    continue block17;
                }
                case DATE: {
                    typeToValMap.put(sqlType, new Integer[]{93});
                    continue block17;
                }
                case BOOLEAN: {
                    typeToValMap.put(sqlType, new Integer[]{16});
                    continue block17;
                }
                case CHAR: {
                    typeToValMap.put(sqlType, new Integer[]{1});
                    continue block17;
                }
                case BYTE: {
                    typeToValMap.put(sqlType, new Integer[]{-6});
                    continue block17;
                }
                case BYTE_ARRAY: {
                    typeToValMap.put(sqlType, new Integer[]{-3});
                    continue block17;
                }
                case SHORT: {
                    typeToValMap.put(sqlType, new Integer[]{5});
                    continue block17;
                }
                case INTEGER: {
                    typeToValMap.put(sqlType, new Integer[]{4});
                    continue block17;
                }
                case LONG: {
                    typeToValMap.put(sqlType, new Integer[]{-5, 3, 2});
                    continue block17;
                }
                case FLOAT: {
                    typeToValMap.put(sqlType, new Integer[]{6});
                    continue block17;
                }
                case DOUBLE: {
                    typeToValMap.put(sqlType, new Integer[]{8});
                    continue block17;
                }
                case SERIALIZABLE: {
                    typeToValMap.put(sqlType, new Integer[]{-3});
                    continue block17;
                }
                case BLOB: {
                    typeToValMap.put(sqlType, new Integer[]{2004});
                    continue block17;
                }
                case UNKNOWN: {
                    typeToValMap.put(sqlType, new Integer[0]);
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException("No JDBC mapping for unknown SqlType " + sqlType);
                }
            }
        }
    }
}

