/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqldbDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "hsqldb";
    private static final String DRIVER_CLASS_NAME = "org.hsqldb.jdbcDriver";
    private static final String DATABASE_NAME = "HSQLdb";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void appendLongStringType(StringBuilder sb, int fieldWidth) {
        sb.append("LONGVARCHAR");
    }

    protected void appendBooleanType(StringBuilder sb, int fieldWidth) {
        sb.append("BIT");
    }

    protected void appendByteArrayType(StringBuilder sb, int fieldWidth) {
        sb.append("BINARY");
    }

    protected void appendSerializableType(StringBuilder sb, int fieldWidth) {
        sb.append("BINARY");
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        StringBuilder seqSb = new StringBuilder(128);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, fieldType.getGeneratedIdSequence());
        if (fieldType.getSqlType() == SqlType.LONG) {
            seqSb.append(" AS BIGINT");
        }
        seqSb.append(" START WITH 1");
        statementsBefore.add(seqSb.toString());
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    public boolean isIdSequenceNeeded() {
        return true;
    }

    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    public boolean isLimitAfterSelect() {
        return true;
    }

    public void appendLimitValue(StringBuilder sb, int limit, Integer offset) {
        sb.append("LIMIT ");
        if (offset == null) {
            sb.append("0 ");
        } else {
            sb.append(offset).append(' ');
        }
        sb.append(limit).append(' ');
    }

    public boolean isOffsetLimitArgument() {
        return true;
    }

    public void appendOffsetValue(StringBuilder sb, int offset) {
        throw new IllegalStateException("Offset is part of the LIMIT in database type " + ((Object)((Object)this)).getClass());
    }

    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("CALL NEXT VALUE FOR ");
        this.appendEscapedEntityName(sb, sequenceName);
    }

    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    public String getPingStatement() {
        return "SELECT COUNT(*) FROM INFORMATION_SCHEMA.SYSTEM_TABLES";
    }
}

