/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "mysql";
    private static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    private static final String DATABASE_NAME = "MySQL";
    public static final String DEFAULT_CREATE_TABLE_SUFFIX = "ENGINE=InnoDB";
    private String createTableSuffix = "ENGINE=InnoDB";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public void setCreateTableSuffix(String createTableSuffix) {
        this.createTableSuffix = createTableSuffix;
    }

    protected void appendDateType(StringBuilder sb, int fieldWidth) {
        sb.append("DATETIME");
    }

    protected void appendBooleanType(StringBuilder sb) {
        sb.append("TINYINT(1)");
    }

    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("AUTO_INCREMENT ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void appendCreateTableSuffix(StringBuilder sb) {
        sb.append(this.createTableSuffix);
        sb.append(' ');
    }

    public boolean isTruncateSupported() {
        return true;
    }

    public boolean isCreateIfNotExistsSupported() {
        return true;
    }
}

