/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.SqlType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TypeValMapper {
    private static final Map<SqlType, Integer[]> typeToValMap = new HashMap<SqlType, Integer[]>();
    private static final Map<Integer, DataType> idValToDataTypeMap = new HashMap<Integer, DataType>();

    public static int getTypeValForSqlType(SqlType sqlType) throws SQLException {
        Integer[] typeVals = typeToValMap.get(sqlType);
        if (typeVals.length == 0) {
            throw new SQLException("SqlType does not have any JDBC type value mapping: " + sqlType);
        }
        return typeVals[0];
    }

    public static DataType getDataTypeForIdTypeVal(int typeVal) {
        return idValToDataTypeMap.get(typeVal);
    }

    static {
        block16: for (SqlType sqlType : SqlType.values()) {
            switch (sqlType) {
                case STRING: {
                    typeToValMap.put(sqlType, new Integer[]{12});
                    continue block16;
                }
                case LONG_STRING: {
                    typeToValMap.put(sqlType, new Integer[]{-1});
                    continue block16;
                }
                case DATE: {
                    typeToValMap.put(sqlType, new Integer[]{93});
                    continue block16;
                }
                case BOOLEAN: {
                    typeToValMap.put(sqlType, new Integer[]{16});
                    continue block16;
                }
                case BYTE: {
                    typeToValMap.put(sqlType, new Integer[]{-6});
                    continue block16;
                }
                case BYTE_ARRAY: {
                    typeToValMap.put(sqlType, new Integer[]{-3});
                    continue block16;
                }
                case SHORT: {
                    typeToValMap.put(sqlType, new Integer[]{5});
                    continue block16;
                }
                case INTEGER: {
                    typeToValMap.put(sqlType, new Integer[]{4});
                    continue block16;
                }
                case LONG: {
                    typeToValMap.put(sqlType, new Integer[]{-5, 3, 2});
                    continue block16;
                }
                case FLOAT: {
                    typeToValMap.put(sqlType, new Integer[]{6});
                    continue block16;
                }
                case DOUBLE: {
                    typeToValMap.put(sqlType, new Integer[]{8});
                    continue block16;
                }
                case SERIALIZABLE: {
                    typeToValMap.put(sqlType, new Integer[]{-3});
                    continue block16;
                }
                case BLOB: {
                    typeToValMap.put(sqlType, new Integer[]{2004});
                    continue block16;
                }
                case UNKNOWN: {
                    typeToValMap.put(sqlType, new Integer[0]);
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("No JDBC mapping for unknown SqlType " + sqlType);
                }
            }
        }
        for (SqlType sqlType : DataType.values()) {
            Integer[] types = typeToValMap.get(sqlType.getSqlType());
            if (!sqlType.isConvertableId()) continue;
            Integer[] arr$ = types;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int typeVal = arr$[i$];
                idValToDataTypeMap.put(typeVal, (DataType)sqlType);
            }
        }
    }
}

