/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlServerDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "sqlserver";
    private static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DATABASE_NAME = "SQL Server";
    private static final FieldConverter byteConverter = new ByteFieldConverter();
    private static final FieldConverter booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public FieldConverter getFieldConverter(DataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                return booleanConverter;
            }
            case BYTE: {
                return byteConverter;
            }
        }
        return super.getFieldConverter(dataType);
    }

    protected void appendBooleanType(StringBuilder sb) {
        sb.append("BIT");
    }

    protected void appendByteType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    protected void appendDateType(StringBuilder sb, int fieldWidth) {
        sb.append("DATETIME");
    }

    protected void appendSerializableType(StringBuilder sb) {
        sb.append("IMAGE");
    }

    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    public boolean isLimitAfterSelect() {
        return true;
    }

    public void appendLimitValue(StringBuilder sb, int limit, Integer offset) {
        sb.append("TOP ").append(limit).append(' ');
    }

    public boolean isOffsetSqlSupported() {
        return false;
    }

    private static class ByteFieldConverter
    implements FieldConverter {
        private ByteFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BYTE;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            byte byteVal = (Byte)javaObject;
            return (short)byteVal;
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int dbColumnPos) throws SQLException {
            short shortVal = results.getShort(dbColumnPos);
            if (shortVal < -128) {
                return (byte)-128;
            }
            if (shortVal > 127) {
                return (byte)127;
            }
            return (byte)shortVal;
        }

        public boolean isStreamType() {
            return false;
        }
    }
}

