/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcPooledConnectionSource
extends JdbcConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcPooledConnectionSource.class);
    private static final int DEFAULT_MAX_CONNECTIONS_FREE = 5;
    private static final int DEFAULT_MAX_CONNECTION_AGE_MILLIS = 3600000;
    private int maxConnectionsFree = 5;
    private long maxConnectionAgeMillis = 3600000L;
    private List<ConnectionMetaData> connFreeList = new ArrayList<ConnectionMetaData>();
    private Map<DatabaseConnection, ConnectionMetaData> connectionMap = new HashMap<DatabaseConnection, ConnectionMetaData>();
    private final Object lock = new Object();
    private int openCount = 0;
    private int closeCount = 0;
    private int maxEverUsed = 0;

    public JdbcPooledConnectionSource() {
    }

    public JdbcPooledConnectionSource(String url) throws SQLException {
        super(url, null, null, null);
    }

    public JdbcPooledConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        super(url, null, null, databaseType);
    }

    public JdbcPooledConnectionSource(String url, String username, String password) throws SQLException {
        super(url, username, password, null);
    }

    public JdbcPooledConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        super(url, username, password, databaseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.checkInitializedSqlException();
        logger.debug("closing", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            for (ConnectionMetaData connMetaData : this.connFreeList) {
                this.closeConnection(connMetaData.connection);
            }
            this.connFreeList.clear();
            this.connFreeList = null;
            this.connectionMap.clear();
        }
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        return this.getReadWriteConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection getReadWriteConnection() throws SQLException {
        this.checkInitializedSqlException();
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            while (this.connFreeList.size() > 0) {
                ConnectionMetaData connMetaData = this.connFreeList.remove(0);
                if (connMetaData.isExpired(now)) {
                    this.closeConnection(connMetaData.connection);
                    continue;
                }
                logger.debug("reusing connection {}", new Object[]{connMetaData});
                return connMetaData.connection;
            }
            JdbcDatabaseConnection connection = this.makeConnection(logger);
            ++this.openCount;
            this.connectionMap.put(connection, new ConnectionMetaData(connection));
            int maxInUse = this.connectionMap.size();
            if (maxInUse > this.maxEverUsed) {
                this.maxEverUsed = maxInUse;
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        this.checkInitializedSqlException();
        if (this.isSavedConnection(connection)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (connection.isClosed()) {
                ConnectionMetaData meta = this.connectionMap.remove(connection);
                if (meta == null) {
                    logger.debug("dropping already closed unknown connection {}", new Object[]{connection});
                } else {
                    logger.debug("dropping already closed connection {}", new Object[]{meta});
                }
                return;
            }
            if (this.connFreeList == null) {
                this.closeConnection(connection);
                return;
            }
            ConnectionMetaData meta = this.connectionMap.get(connection);
            if (meta == null) {
                logger.error("should have found connection {} in the map", new Object[]{connection});
                this.closeConnection(connection);
            } else {
                this.connFreeList.add(meta);
                logger.debug("cache released connection {}", new Object[]{meta});
                if (this.connFreeList.size() > this.maxConnectionsFree) {
                    meta = this.connFreeList.remove(0);
                    logger.debug("cache too full, closing connection {}", new Object[]{meta});
                    this.closeConnection(meta.connection);
                }
            }
        }
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) {
        this.checkInitializedIllegalStateException();
        boolean saved = this.saveSpecial(connection);
        if (logger.isLevelEnabled(Log.Level.DEBUG)) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            logger.debug("saved special connection {}", new Object[]{meta});
        }
        return saved;
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
        this.checkInitializedIllegalStateException();
        boolean cleared = this.clearSpecial(connection, logger);
        if (logger.isLevelEnabled(Log.Level.DEBUG)) {
            ConnectionMetaData meta = this.connectionMap.get(connection);
            if (cleared) {
                logger.debug("cleared special connection {}", new Object[]{meta});
            } else {
                logger.debug("special connection {} not saved", new Object[]{meta});
            }
        }
    }

    public void setUsesTransactions(boolean usesTransactions) {
        this.usedSpecialConnection = usesTransactions;
    }

    public void setMaxConnectionsFree(int maxConnectionsFree) {
        this.maxConnectionsFree = maxConnectionsFree;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAgeMillis) {
        this.maxConnectionAgeMillis = maxConnectionAgeMillis;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public int getMaxConnectionsEverUsed() {
        return this.maxEverUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentConnectionsManaged() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionMap.size();
        }
    }

    private void checkInitializedSqlException() throws SQLException {
        if (!this.initialized) {
            throw new SQLException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
    }

    private void checkInitializedIllegalStateException() {
        if (!this.initialized) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " was not initialized properly");
        }
    }

    private void closeConnection(DatabaseConnection connection) throws SQLException {
        ConnectionMetaData meta = this.connectionMap.remove(connection);
        connection.close();
        logger.debug("closed connection {}", new Object[]{meta});
        ++this.closeCount;
    }

    private class ConnectionMetaData {
        public final DatabaseConnection connection;
        private final long expiresMillis;

        public ConnectionMetaData(DatabaseConnection connection) {
            this.connection = connection;
            long now = System.currentTimeMillis();
            this.expiresMillis = JdbcPooledConnectionSource.this.maxConnectionAgeMillis > Long.MAX_VALUE - now ? Long.MAX_VALUE : now + JdbcPooledConnectionSource.this.maxConnectionAgeMillis;
        }

        public boolean isExpired(long now) {
            return this.expiresMillis <= now;
        }

        public String toString() {
            return "@" + Integer.toHexString(this.hashCode());
        }
    }
}

