/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.jdbc.JdbcCompiledStatement;
import com.j256.ormlite.jdbc.JdbcDatabaseResults;
import com.j256.ormlite.jdbc.TypeValMapper;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDatabaseConnection
implements DatabaseConnection {
    private static Object[] noArgs = new Object[0];
    private static SqlType[] noArgTypes = new SqlType[0];
    private static GenericRowMapper<Long> longWrapper = new OneLongWrapper();
    private final Connection connection;
    private Boolean supportsSavePoints = null;

    public JdbcDatabaseConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isAutoCommitSupported() throws SQLException {
        return true;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public Savepoint setSavePoint(String name) throws SQLException {
        if (this.supportsSavePoints == null) {
            DatabaseMetaData metaData = this.connection.getMetaData();
            this.supportsSavePoints = metaData.supportsSavepoints();
        }
        if (this.supportsSavePoints.booleanValue()) {
            return this.connection.setSavepoint(name);
        }
        return null;
    }

    @Override
    public void commit(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.commit();
        } else {
            this.connection.releaseSavepoint(savepoint);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            this.connection.rollback();
        } else {
            this.connection.rollback(savepoint);
        }
    }

    @Override
    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type) throws SQLException {
        return new JdbcCompiledStatement(this.connection.prepareStatement(statement, 1003, 1007), type);
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public int insert(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes);
    }

    @Override
    public int insert(String statement, Object[] args, SqlType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement, 1);
        this.statementSetArgs(stmt, args, argFieldTypes);
        int rowN = stmt.executeUpdate();
        JdbcDatabaseResults results = new JdbcDatabaseResults(stmt, stmt.getGeneratedKeys());
        if (results == null) {
            throw new SQLException("No generated key results returned from update: " + statement);
        }
        int colN = results.getColumnCount();
        while (results.next()) {
            for (int colC = 1; colC <= colN; ++colC) {
                Number id = results.getIdColumnData(colC);
                keyHolder.addKey(id);
            }
        }
        return rowN;
    }

    @Override
    public int update(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement);
        this.statementSetArgs(stmt, args, argFieldTypes);
        return stmt.executeUpdate();
    }

    @Override
    public int delete(String statement, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        return this.update(statement, args, argFieldTypes);
    }

    @Override
    public <T> Object queryForOne(String statement, Object[] args, SqlType[] argFieldTypes, GenericRowMapper<T> rowMapper) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement, 1003, 1007);
        this.statementSetArgs(stmt, args, argFieldTypes);
        JdbcDatabaseResults results = new JdbcDatabaseResults(stmt, stmt.executeQuery());
        if (!results.next()) {
            return null;
        }
        T first = rowMapper.mapRow(results);
        if (results.next()) {
            return MORE_THAN_ONE;
        }
        return first;
    }

    @Override
    public long queryForLong(String statement) throws SQLException {
        Object result = this.queryForOne(statement, noArgs, noArgTypes, longWrapper);
        if (result == null) {
            throw new SQLException("No results returned in query-for-long: " + statement);
        }
        if (result == MORE_THAN_ONE) {
            throw new SQLException("More than 1 result returned in query-for-long: " + statement);
        }
        return (Long)result;
    }

    private void statementSetArgs(PreparedStatement stmt, Object[] args, SqlType[] argFieldTypes) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int typeVal = TypeValMapper.getTypeValForSqlType(argFieldTypes[i]);
            if (arg == null) {
                stmt.setNull(i + 1, typeVal);
                continue;
            }
            stmt.setObject(i + 1, arg, typeVal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneLongWrapper
    implements GenericRowMapper<Long> {
        private OneLongWrapper() {
        }

        @Override
        public Long mapRow(DatabaseResults rs) throws SQLException {
            return rs.getLong(1);
        }
    }
}

