/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.jdbc.JdbcDatabaseConnection;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionSource
implements ConnectionSource {
    private DataSource dataSource;

    public DataSourceConnectionSource() {
    }

    public DataSourceConnectionSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void initialize() {
        if (this.dataSource == null) {
            throw new IllegalStateException("dataSource was never set on " + this.getClass().getSimpleName());
        }
    }

    public DatabaseConnection getReadOnlyConnection() throws SQLException {
        return this.getReadWriteConnection();
    }

    public DatabaseConnection getReadOnlyConnection(String username, String password) throws SQLException {
        return this.getReadWriteConnection(username, password);
    }

    public DatabaseConnection getReadWriteConnection() throws SQLException {
        return new JdbcDatabaseConnection(this.dataSource.getConnection());
    }

    public void releaseConnection(DatabaseConnection connection) throws SQLException {
    }

    public DatabaseConnection getReadWriteConnection(String username, String password) throws SQLException {
        return new JdbcDatabaseConnection(this.dataSource.getConnection(username, password));
    }

    public void close() throws SQLException {
    }
}

