/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "oracle";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";

    @Override
    public String getDriverUrlPart() {
        return DATABASE_URL_PORTION;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    protected void appendStringType(StringBuilder sb, int fieldWidth) {
        sb.append("VARCHAR2(").append(fieldWidth).append(")");
    }

    @Override
    protected void appendByteType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendLongType(StringBuilder sb) {
        sb.append("NUMERIC");
    }

    @Override
    protected void appendObjectType(StringBuilder sb) {
        sb.append("LONG RAW");
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String seqName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder();
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, seqName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("PRIMARY KEY ");
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT ");
        this.appendEscapedEntityName(sb, sequenceName);
        sb.append(".nextval FROM dual");
    }
}

