/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqldbDatabaseType
extends BaseDatabaseType
implements DatabaseType {
    private static final String DATABASE_URL_PORTION = "hsqldb";
    private static final String DRIVER_CLASS_NAME = "org.hsqldb.jdbcDriver";

    @Override
    public String getDriverUrlPart() {
        return DATABASE_URL_PORTION;
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    protected void appendBooleanType(StringBuilder sb) {
        sb.append("BIT");
    }

    @Override
    protected void appendObjectType(StringBuilder sb) {
        sb.append("BINARY");
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        StringBuilder seqSb = new StringBuilder();
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, fieldType.getGeneratedIdSequence());
        if (fieldType.getDataType() == DataType.LONG) {
            seqSb.append(" AS BIGINT");
        }
        seqSb.append(" START WITH 1");
        statementsBefore.add(seqSb.toString());
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('\"').append(word).append('\"');
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder();
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return true;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, int limit) {
        sb.append("LIMIT 0 ").append(limit).append(' ');
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("CALL NEXT VALUE FOR ");
        this.appendEscapedEntityName(sb, sequenceName);
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }
}

