/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LocalLog
implements Log {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.ormlite.logger.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.ormlite.logger.file";
    private static final Level DEFAULT_LEVEL = Level.DEBUG;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final String className;
    private final Level level;
    private final PrintStream printStream;

    public LocalLog(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        String levelName = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
        if (levelName == null) {
            this.level = DEFAULT_LEVEL;
        } else {
            Level matchedLevel;
            try {
                matchedLevel = Level.valueOf(levelName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Level '" + levelName + "' was not found", e);
            }
            this.level = matchedLevel;
        }
        String logPath = System.getProperty(LOCAL_LOG_FILE_PROPERTY);
        if (logPath == null) {
            this.printStream = System.out;
        } else {
            try {
                this.printStream = new PrintStream(new File(logPath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Log file " + logPath + " was not found", e);
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    public void trace(String msg) {
        this.printMessage(Level.TRACE, msg, null);
    }

    public void trace(String msg, Throwable throwable) {
        this.printMessage(Level.TRACE, msg, throwable);
    }

    public void debug(String msg) {
        this.printMessage(Level.DEBUG, msg, null);
    }

    public void debug(String msg, Throwable throwable) {
        this.printMessage(Level.DEBUG, msg, throwable);
    }

    public void info(String msg) {
        this.printMessage(Level.INFO, msg, null);
    }

    public void info(String msg, Throwable throwable) {
        this.printMessage(Level.INFO, msg, throwable);
    }

    public void warn(String msg) {
        this.printMessage(Level.WARN, msg, null);
    }

    public void warn(String msg, Throwable throwable) {
        this.printMessage(Level.WARN, msg, throwable);
    }

    public void error(String msg) {
        this.printMessage(Level.ERROR, msg, null);
    }

    public void error(String msg, Throwable throwable) {
        this.printMessage(Level.ERROR, msg, throwable);
    }

    public void fatal(String msg) {
        this.printMessage(Level.FATAL, msg, null);
    }

    public void fatal(String msg, Throwable throwable) {
        this.printMessage(Level.FATAL, msg, throwable);
    }

    void flush() {
        this.printStream.flush();
    }

    private void printMessage(Level level, String message, Throwable throwable) {
        if (!this.level.isEnabled(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dateFormat.format(new Date()));
        sb.append(" [").append(level.name()).append("] ");
        sb.append(this.className).append(' ');
        sb.append(message);
        this.printStream.println(sb.toString());
        if (throwable != null) {
            throwable.printStackTrace(this.printStream);
        }
    }

    private boolean isEnabled(Level level) {
        return this.level.isEnabled(level);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE(1),
        DEBUG(2),
        INFO(3),
        WARN(4),
        ERROR(5),
        FATAL(6);

        private int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean isEnabled(Level otherLevel) {
            return this.level <= otherLevel.level;
        }
    }
}

