/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.DatabaseTableConfigLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmLiteConfigUtil {
    protected static final String RESOURCE_DIR_NAME = "res";
    protected static final String RAW_DIR_NAME = "raw";
    protected static int maxFindSourceLevel = 20;
    private static final DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("Main can take a single file-name argument.");
        }
        OrmLiteConfigUtil.writeConfigFile(args[0]);
    }

    public static void writeConfigFile(String fileName) throws SQLException, IOException {
        List<Class<?>> classList = OrmLiteConfigUtil.findAnnotatedClasses(new File("."), 0);
        OrmLiteConfigUtil.writeConfigFile(fileName, classList.toArray(new Class[classList.size()]));
    }

    public static void writeConfigFile(String fileName, Class<?>[] classes) throws SQLException, IOException {
        File rawDir = OrmLiteConfigUtil.findRawDir(new File("."));
        if (rawDir == null) {
            System.err.println("Could not find raw directory");
        } else {
            File configFile = new File(rawDir, fileName);
            OrmLiteConfigUtil.writeConfigFile(configFile, classes);
        }
    }

    public static void writeConfigFile(File configFile) throws SQLException, IOException {
        OrmLiteConfigUtil.writeConfigFile(configFile, new File("."));
    }

    public static void writeConfigFile(File configFile, File searchDir) throws SQLException, IOException {
        List<Class<?>> classList = OrmLiteConfigUtil.findAnnotatedClasses(searchDir, 0);
        OrmLiteConfigUtil.writeConfigFile(configFile, classList.toArray(new Class[classList.size()]));
    }

    public static void writeConfigFile(File configFile, Class<?>[] classes) throws SQLException, IOException {
        System.out.println("Writing configurations to " + configFile.getAbsolutePath());
        OrmLiteConfigUtil.writeConfigFile((OutputStream)new FileOutputStream(configFile), classes);
    }

    public static void writeConfigFile(OutputStream outputStream, File searchDir) throws SQLException, IOException {
        List<Class<?>> classList = OrmLiteConfigUtil.findAnnotatedClasses(searchDir, 0);
        OrmLiteConfigUtil.writeConfigFile(outputStream, classList.toArray(new Class[classList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfigFile(OutputStream outputStream, Class<?>[] classes) throws SQLException, IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream), 4096);
        try {
            OrmLiteConfigUtil.writeHeader(writer);
            for (Class<?> clazz : classes) {
                OrmLiteConfigUtil.writeConfigForTable(writer, clazz);
            }
            System.out.println("Done.");
        }
        finally {
            writer.close();
        }
    }

    protected static File findRawDir(File dir) {
        for (int i = 0; dir != null && i < 20; dir = dir.getParentFile(), ++i) {
            File rawDir = OrmLiteConfigUtil.findResRawDir(dir);
            if (rawDir == null) continue;
            return rawDir;
        }
        return null;
    }

    private static void writeHeader(BufferedWriter writer) throws IOException {
        writer.append('#');
        writer.newLine();
        writer.append("# generated on ").append(new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").format(new Date()));
        writer.newLine();
        writer.append('#');
        writer.newLine();
    }

    private static List<Class<?>> findAnnotatedClasses(File dir, int level) throws SQLException, IOException {
        ArrayList classList = new ArrayList();
        for (File file : dir.listFiles()) {
            Class<?> clazz;
            if (file.isDirectory()) {
                if (level >= maxFindSourceLevel) continue;
                OrmLiteConfigUtil.findAnnotatedClasses(file, level + 1);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            String packageName = OrmLiteConfigUtil.getPackageOfClass(file);
            if (packageName == null) {
                System.err.println("Could not find package name for: " + file);
                continue;
            }
            String name = file.getName();
            name = name.substring(0, name.length() - ".java".length());
            String className = packageName + "." + name;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable t) {
                System.err.println("Could not load class file for: " + file);
                System.err.println("     " + t);
                continue;
            }
            if (OrmLiteConfigUtil.classHasAnnotations(clazz)) {
                classList.add(clazz);
            }
            for (Class<?> innerClazz : clazz.getDeclaredClasses()) {
                if (!OrmLiteConfigUtil.classHasAnnotations(innerClazz)) continue;
                classList.add(innerClazz);
            }
        }
        return classList;
    }

    private static void writeConfigForTable(BufferedWriter writer, Class<?> clazz) throws SQLException, IOException {
        String tableName = DatabaseTableConfig.extractTableName(clazz);
        ArrayList<DatabaseFieldConfig> fieldConfigs = new ArrayList<DatabaseFieldConfig>();
        try {
            for (Class<?> working = clazz; working != null; working = working.getSuperclass()) {
                for (Field field : working.getDeclaredFields()) {
                    DatabaseFieldConfig fieldConfig = DatabaseFieldConfig.fromField((DatabaseType)databaseType, (String)tableName, (Field)field);
                    if (fieldConfig == null) continue;
                    fieldConfigs.add(fieldConfig);
                }
            }
        }
        catch (Error e) {
            System.err.println("Skipping " + clazz + " because we got an error finding its definition: " + e.getMessage());
            return;
        }
        if (fieldConfigs.isEmpty()) {
            System.out.println("Skipping " + clazz + " because no annotated fields found");
            return;
        }
        DatabaseTableConfig tableConfig = new DatabaseTableConfig(clazz, tableName, fieldConfigs);
        DatabaseTableConfigLoader.write((BufferedWriter)writer, (DatabaseTableConfig)tableConfig);
        writer.append("#################################");
        writer.newLine();
        System.out.println("Wrote config for " + clazz);
    }

    private static boolean classHasAnnotations(Class<?> clazz) {
        while (clazz != null) {
            Field[] fields;
            if (clazz.getAnnotation(DatabaseTable.class) != null) {
                return true;
            }
            try {
                fields = clazz.getDeclaredFields();
            }
            catch (Throwable t) {
                System.err.println("Could not load get delcared fields from: " + clazz);
                System.err.println("     " + t);
                return false;
            }
            for (Field field : fields) {
                if (field.getAnnotation(DatabaseField.class) == null && field.getAnnotation(ForeignCollectionField.class) == null) continue;
                return true;
            }
            try {
                clazz = clazz.getSuperclass();
            }
            catch (Throwable t) {
                System.err.println("Could not get super class for: " + clazz);
                System.err.println("     " + t);
                return false;
            }
        }
        return false;
    }

    private static String getPackageOfClass(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            while (true) {
                String[] parts;
                String line;
                if ((line = reader.readLine()) == null) {
                    String string = null;
                    return string;
                }
                if (!line.contains("package") || (parts = line.split("[ \t;]")).length <= 1 || !parts[0].equals("package")) continue;
                String string = parts[1];
                return string;
            }
        }
        finally {
            reader.close();
        }
    }

    private static File findResRawDir(File dir) {
        for (File file : dir.listFiles()) {
            File[] rawFiles;
            if (!file.getName().equals(RESOURCE_DIR_NAME) || !file.isDirectory() || (rawFiles = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().equals(OrmLiteConfigUtil.RAW_DIR_NAME) && file.isDirectory();
                }
            })).length != 1) continue;
            return rawFiles[0];
        }
        return null;
    }
}

