/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDatabaseType
implements DatabaseType {
    protected static int DEFAULT_VARCHAR_WIDTH = 255;
    protected static int DEFAULT_DATE_STRING_WIDTH = 50;
    protected static String DEFAULT_SEQUENCE_SUFFIX = "_id_seq";

    @Override
    public void loadDriver() throws SQLException {
        String className = this.getDriverClassName();
        if (className != null) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw SqlExceptionUtil.create("DatabaseType driver class was not found: " + className, e);
            }
        }
    }

    @Override
    public void appendColumnArg(StringBuilder sb, FieldType fieldType, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) {
        this.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        sb.append(' ');
        switch (fieldType.getDataType()) {
            case STRING: {
                int fieldWidth = fieldType.getWidth();
                if (fieldWidth == 0) {
                    fieldWidth = this.getDefaultVarcharWidth();
                }
                this.appendStringType(sb, fieldWidth);
                break;
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                this.appendBooleanType(sb);
                break;
            }
            case JAVA_DATE: {
                int fieldWidth = fieldType.getWidth();
                if (fieldWidth == 0) {
                    fieldWidth = DEFAULT_DATE_STRING_WIDTH;
                }
                this.appendDateType(sb, fieldWidth);
                break;
            }
            case JAVA_DATE_LONG: {
                this.appendDateLongType(sb);
                break;
            }
            case JAVA_DATE_STRING: {
                int fieldWidth = fieldType.getWidth();
                if (fieldWidth == 0) {
                    fieldWidth = DEFAULT_DATE_STRING_WIDTH;
                }
                this.appendDateStringType(sb, fieldWidth);
                break;
            }
            case BYTE: 
            case BYTE_OBJ: {
                this.appendByteType(sb);
                break;
            }
            case SHORT: 
            case SHORT_OBJ: {
                this.appendShortType(sb);
                break;
            }
            case INTEGER: 
            case INTEGER_OBJ: {
                this.appendIntegerType(sb);
                break;
            }
            case LONG: 
            case LONG_OBJ: {
                this.appendLongType(sb);
                break;
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                this.appendFloatType(sb);
                break;
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                this.appendDoubleType(sb);
                break;
            }
            case SERIALIZABLE: {
                this.appendObjectType(sb);
                break;
            }
            case ENUM_STRING: {
                this.appendEnumStringType(sb, fieldType);
                break;
            }
            case ENUM_INTEGER: {
                this.appendEnumIntType(sb, fieldType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field type " + fieldType.getDataType());
            }
        }
        sb.append(' ');
        if (fieldType.isGeneratedIdSequence()) {
            this.configureGeneratedIdSequence(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        } else if (fieldType.isGeneratedId()) {
            this.configureGeneratedId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        } else if (fieldType.isId()) {
            this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        }
        if (!fieldType.isGeneratedId()) {
            Object defaultValue = fieldType.getDefaultValue();
            if (defaultValue != null) {
                sb.append("DEFAULT ");
                this.appendDefaultValue(sb, fieldType, defaultValue);
                sb.append(' ');
            }
            if (fieldType.isCanBeNull()) {
                this.appendCanBeNull(sb, fieldType);
            } else {
                sb.append("NOT NULL ");
            }
            if (fieldType.isUnique()) {
                this.appendUnique(sb, fieldType, statementsAfter);
            }
        }
    }

    @Override
    public String convertColumnName(String columnName) {
        return columnName;
    }

    protected void appendStringType(StringBuilder sb, int fieldWidth) {
        if (this.isVarcharFieldWidthSupported()) {
            sb.append("VARCHAR(").append(fieldWidth).append(")");
        } else {
            sb.append("VARCHAR");
        }
    }

    protected void appendDateType(StringBuilder sb, int fieldWidth) {
        sb.append("TIMESTAMP");
    }

    protected void appendDateLongType(StringBuilder sb) {
        this.appendLongType(sb);
    }

    protected void appendDateStringType(StringBuilder sb, int fieldWidth) {
        this.appendStringType(sb, fieldWidth);
    }

    protected void appendBooleanType(StringBuilder sb) {
        sb.append("BOOLEAN");
    }

    protected void appendByteType(StringBuilder sb) {
        sb.append("TINYINT");
    }

    protected void appendShortType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    protected void appendIntegerType(StringBuilder sb) {
        sb.append("INTEGER");
    }

    protected void appendLongType(StringBuilder sb) {
        sb.append("BIGINT");
    }

    protected void appendFloatType(StringBuilder sb) {
        sb.append("FLOAT");
    }

    protected void appendDoubleType(StringBuilder sb) {
        sb.append("DOUBLE PRECISION");
    }

    protected void appendObjectType(StringBuilder sb) {
        sb.append("VARBINARY");
    }

    protected void appendEnumStringType(StringBuilder sb, FieldType fieldType) {
        this.appendStringType(sb, DEFAULT_VARCHAR_WIDTH);
    }

    protected void appendEnumIntType(StringBuilder sb, FieldType fieldType) {
        this.appendIntegerType(sb);
    }

    protected void appendDefaultValue(StringBuilder sb, FieldType fieldType, Object defaultValue) {
        if (fieldType.isEscapeDefaultValue()) {
            this.appendEscapedWord(sb, defaultValue.toString());
        } else {
            sb.append(defaultValue);
        }
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        throw new IllegalStateException("GeneratedIdSequence is not supported by this database type for " + fieldType);
    }

    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        throw new IllegalStateException("GeneratedId is not supported by this database type for " + fieldType);
    }

    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        StringBuilder primaryKeySb = new StringBuilder();
        primaryKeySb.append("PRIMARY KEY (");
        this.appendEscapedEntityName(primaryKeySb, fieldType.getDbColumnName());
        primaryKeySb.append(") ");
        additionalArgs.add(primaryKeySb.toString());
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
    }

    @Override
    public void appendEscapedWord(StringBuilder sb, String word) {
        sb.append('\'').append(word).append('\'');
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('`').append(word).append('`');
    }

    @Override
    public String generateIdSequenceName(String tableName, FieldType idFieldType) {
        String name = tableName + DEFAULT_SEQUENCE_SUFFIX;
        if (this.isEntityNamesMustBeUpCase()) {
            return name.toUpperCase();
        }
        return name;
    }

    @Override
    public String getCommentLinePrefix() {
        return "-- ";
    }

    @Override
    public FieldConverter getFieldConverter(DataType dataType) {
        return dataType;
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return true;
    }

    @Override
    public boolean isLimitSqlSupported() {
        return true;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return false;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, int limit) {
        sb.append("LIMIT ").append(limit).append(' ');
    }

    protected int getDefaultVarcharWidth() {
        return DEFAULT_VARCHAR_WIDTH;
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
    }

    @Override
    public void appendCreateTableSuffix(StringBuilder sb) {
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return true;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return false;
    }

    @Override
    public boolean isNestedSavePointsSupported() {
        return true;
    }

    protected void appendCanBeNull(StringBuilder sb, FieldType fieldType) {
    }

    protected void appendUnique(StringBuilder sb, FieldType fieldType, List<String> statementsAfter) {
        sb.append("UNIQUE ");
    }

    protected static class BooleanNumberFieldConverter
    implements FieldConverter {
        protected BooleanNumberFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BOOLEAN;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            boolean bool = Boolean.parseBoolean(defaultStr);
            return bool ? new Byte(1) : new Byte(0);
        }

        public Object javaToArg(FieldType fieldType, Object obj) throws SQLException {
            Boolean bool = (Boolean)obj;
            return bool != false ? new Byte(1) : new Byte(0);
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            byte result = results.getByte(columnPos);
            return result == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }

        public boolean isStreamType() {
            return false;
        }
    }
}

