/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android;

import android.database.Cursor;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;

public class AndroidDatabaseResults
implements DatabaseResults {
    private final Cursor cursor;
    private boolean firstCall;
    private static final DatabaseType databaseType = new SqliteAndroidDatabaseType();

    public AndroidDatabaseResults(Cursor cursor) {
        this.cursor = cursor;
        this.firstCall = true;
    }

    public int getColumnCount() throws SQLException {
        return this.cursor.getColumnCount();
    }

    public String getColumnName(int column) throws SQLException {
        return this.cursor.getColumnName(column);
    }

    public boolean next() throws SQLException {
        boolean returnValue;
        if (this.firstCall) {
            returnValue = this.cursor.moveToFirst();
            this.firstCall = false;
        } else {
            returnValue = this.cursor.moveToNext();
        }
        return returnValue;
    }

    public int findColumn(String columnName) throws SQLException {
        int index = this.cursor.getColumnIndex(columnName);
        if (index < 0) {
            StringBuilder sb = new StringBuilder();
            databaseType.appendEscapedEntityName(sb, columnName);
            index = this.cursor.getColumnIndex(sb.toString());
            if (index < 0) {
                throw new SQLException("Unknown field '" + columnName + "' from the Android sqlite cursor");
            }
        }
        return AndroidDatabaseResults.androidColumnIndexToJdbc(index);
    }

    public String getString(int columnIndex) throws SQLException {
        return this.cursor.getString(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        int col = AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex);
        return !this.cursor.isNull(col) && this.cursor.getShort(col) != 0;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getShort(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.cursor.getBlob(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.cursor.getShort(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.cursor.getInt(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.cursor.getLong(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.cursor.getFloat(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.cursor.getDouble(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLException("Android does not support timestamp.  Use JAVA_DATE_LONG or JAVA_DATE_STRING types");
    }

    public InputStream getBlobStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.cursor.getBlob(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex)));
    }

    public boolean isNull(int columnIndex) throws SQLException {
        return this.cursor.isNull(AndroidDatabaseResults.jdbcColumnIndexToAndroid(columnIndex));
    }

    public static int jdbcColumnIndexToAndroid(int columnIndex) {
        return columnIndex - 1;
    }

    public static int androidColumnIndexToJdbc(int columnIndex) {
        return columnIndex + 1;
    }
}

