/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.JavaxPersistence;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.table.DatabaseTable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTableConfig<T> {
    private Class<T> dataClass;
    private String tableName;
    private List<DatabaseFieldConfig> fieldConfigs;
    private FieldType[] fieldTypes;

    public DatabaseTableConfig() {
    }

    public DatabaseTableConfig(Class<T> dataClass, List<DatabaseFieldConfig> fieldConfigs) {
        this(dataClass, DatabaseTableConfig.extractTableName(dataClass), fieldConfigs);
    }

    public DatabaseTableConfig(Class<T> dataClass, String tableName, List<DatabaseFieldConfig> fieldConfigs) {
        this.dataClass = dataClass;
        this.tableName = tableName;
        this.fieldConfigs = fieldConfigs;
    }

    private DatabaseTableConfig(Class<T> dataClass, String tableName, FieldType[] fieldTypes) {
        this.dataClass = dataClass;
        this.tableName = tableName;
        this.fieldTypes = fieldTypes;
    }

    public void initialize() {
        if (this.dataClass == null) {
            throw new IllegalStateException("dataClass was never set on " + this.getClass().getSimpleName());
        }
        if (this.tableName == null) {
            this.tableName = DatabaseTableConfig.extractTableName(this.dataClass);
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<T> dataClass) {
        this.dataClass = dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName.toLowerCase();
    }

    public void setFieldConfigs(List<DatabaseFieldConfig> fieldConfigs) {
        this.fieldConfigs = fieldConfigs;
    }

    public FieldType[] extractFieldTypes(DatabaseType databaseType) throws SQLException {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.fieldConfigs == null ? DatabaseTableConfig.extractFieldTypes(databaseType, this.dataClass, this.tableName) : this.convertFieldConfigs(databaseType, this.tableName, this.fieldConfigs);
        }
        return this.fieldTypes;
    }

    public static <T> DatabaseTableConfig<T> fromClass(DatabaseType databaseType, Class<T> clazz) throws SQLException {
        String tableName = DatabaseTableConfig.extractTableName(clazz);
        if (databaseType.isEntityNamesMustBeUpCase()) {
            tableName = tableName.toUpperCase();
        }
        return new DatabaseTableConfig<T>(clazz, tableName, DatabaseTableConfig.extractFieldTypes(databaseType, clazz, tableName));
    }

    private static <T> FieldType[] extractFieldTypes(DatabaseType databaseType, Class<T> clazz, String tableName) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (Field field : clazz.getDeclaredFields()) {
            FieldType fieldType = FieldType.createFieldType(databaseType, tableName, field);
            if (fieldType == null) continue;
            fieldTypes.add(fieldType);
        }
        if (fieldTypes.size() == 0) {
            throw new IllegalArgumentException("No fields have a " + DatabaseField.class.getSimpleName() + " annotation in " + clazz);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }

    private static <T> String extractTableName(Class<T> clazz) {
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        String name = null;
        if (databaseTable != null && databaseTable.tableName() != null && databaseTable.tableName().length() > 0) {
            name = databaseTable.tableName();
        } else {
            name = JavaxPersistence.getEntityName(clazz);
            if (name == null) {
                name = clazz.getSimpleName().toLowerCase();
            }
        }
        return name;
    }

    private FieldType[] convertFieldConfigs(DatabaseType databaseType, String tableName, List<DatabaseFieldConfig> fieldConfigs) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (DatabaseFieldConfig fieldConfig : fieldConfigs) {
            Field field;
            try {
                field = this.dataClass.getDeclaredField(fieldConfig.getFieldName());
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not configure field with name '" + fieldConfig.getFieldName() + "' for " + this.dataClass, e);
            }
            FieldType fieldType = new FieldType(databaseType, tableName, field, fieldConfig);
            fieldTypes.add(fieldType);
        }
        if (fieldTypes.size() == 0) {
            throw new SQLException("No fields were configured for class " + this.dataClass);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }
}

