/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.cipher.android;

import android.database.SQLException;
import com.j256.ormlite.cipher.android.AndroidCompiledStatement;
import com.j256.ormlite.cipher.android.AndroidDatabaseResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.misc.VersionUtils;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.support.GeneratedKeyHolder;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Savepoint;
import net.sqlcipher.Cursor;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteStatement;

public class AndroidDatabaseConnection
implements DatabaseConnection {
    private static final String ANDROID_VERSION = "VERSION__5.1-SNAPSHOT__";
    private static Logger logger = LoggerFactory.getLogger(AndroidDatabaseConnection.class);
    private static final String[] NO_STRING_ARGS = new String[0];
    private final SQLiteDatabase db;
    private final boolean readWrite;
    private final boolean cancelQueriesEnabled;

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite) {
        this(db, readWrite, false);
    }

    public AndroidDatabaseConnection(SQLiteDatabase db, boolean readWrite, boolean cancelQueriesEnabled) {
        this.db = db;
        this.readWrite = readWrite;
        this.cancelQueriesEnabled = cancelQueriesEnabled;
        logger.trace("{}: db {} opened, read-write = {}", (Object)this, (Object)db, (Object)readWrite);
    }

    public boolean isAutoCommitSupported() {
        return true;
    }

    public boolean isAutoCommit() throws java.sql.SQLException {
        try {
            boolean inTransaction = this.db.inTransaction();
            logger.trace("{}: in transaction is {}", (Object)this, (Object)inTransaction);
            return !inTransaction;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems getting auto-commit from database", (Throwable)e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        if (autoCommit) {
            if (this.db.inTransaction()) {
                this.db.setTransactionSuccessful();
                this.db.endTransaction();
            }
        } else if (!this.db.inTransaction()) {
            this.db.beginTransaction();
        }
    }

    public Savepoint setSavePoint(String name) throws java.sql.SQLException {
        try {
            this.db.beginTransaction();
            logger.trace("{}: save-point set with name {}", (Object)this, (Object)name);
            return new OurSavePoint(name);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("problems beginning transaction " + name), (Throwable)e);
        }
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public void commit(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.setTransactionSuccessful();
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("{}: transaction is successfully ended", (Object)this);
            } else {
                logger.trace("{}: transaction {} is successfully ended", (Object)this, (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            if (savepoint == null) {
                throw SqlExceptionUtil.create((String)"problems committing transaction", (Throwable)e);
            }
            throw SqlExceptionUtil.create((String)("problems committing transaction " + savepoint.getSavepointName()), (Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws java.sql.SQLException {
        try {
            this.db.endTransaction();
            if (savepoint == null) {
                logger.trace("{}: transaction is ended, unsuccessfully", (Object)this);
            } else {
                logger.trace("{}: transaction {} is ended, unsuccessfully", (Object)this, (Object)savepoint.getSavepointName());
            }
        }
        catch (SQLException e) {
            if (savepoint == null) {
                throw SqlExceptionUtil.create((String)"problems rolling back transaction", (Throwable)e);
            }
            throw SqlExceptionUtil.create((String)("problems rolling back transaction " + savepoint.getSavepointName()), (Throwable)e);
        }
    }

    public void releaseSavePoint(Savepoint savePoint) {
    }

    public int executeStatement(String statementStr, int resultFlags) throws java.sql.SQLException {
        return AndroidCompiledStatement.execSql(this.db, statementStr, statementStr, NO_STRING_ARGS);
    }

    public CompiledStatement compileStatement(String statement, StatementBuilder.StatementType type, FieldType[] argFieldTypes, int resultFlags, boolean cacheStore) {
        AndroidCompiledStatement stmt = new AndroidCompiledStatement(statement, this.db, type, this.cancelQueriesEnabled, cacheStore);
        logger.trace("{}: compiled statement got {}: {}", (Object)this, (Object)stmt, (Object)statement);
        return stmt;
    }

    public int insert(String statement, Object[] args, FieldType[] argFieldTypes, GeneratedKeyHolder keyHolder) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            long rowId = stmt.executeInsert();
            if (keyHolder != null) {
                keyHolder.addKey((Number)rowId);
            }
            int result = 1;
            logger.trace("{}: insert statement is compiled and executed, changed {}: {}", (Object)this, (Object)result, (Object)statement);
            int n = result;
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("inserting to database failed: " + statement), (Throwable)e);
        }
        finally {
            this.closeQuietly(stmt);
        }
    }

    public int update(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.update(statement, args, argFieldTypes, "updated");
    }

    public int delete(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        return this.update(statement, args, argFieldTypes, "deleted");
    }

    public <T> Object queryForOne(String statement, Object[] args, FieldType[] argFieldTypes, GenericRowMapper<T> rowMapper, ObjectCache objectCache) throws java.sql.SQLException {
        Object object;
        Object first;
        AndroidDatabaseResults results;
        Cursor cursor;
        block7: {
            block6: {
                cursor = null;
                results = null;
                cursor = this.db.rawQuery(statement, this.toStrings(args));
                results = new AndroidDatabaseResults(cursor, objectCache, true);
                logger.trace("{}: queried for one result: {}", (Object)this, (Object)statement);
                if (results.first()) break block6;
                Object var8_8 = null;
                IOUtils.closeQuietly((Closeable)((Object)results));
                this.closeQuietly(cursor);
                return var8_8;
            }
            first = rowMapper.mapRow((DatabaseResults)results);
            if (!results.next()) break block7;
            Object object2 = MORE_THAN_ONE;
            IOUtils.closeQuietly((Closeable)((Object)results));
            this.closeQuietly(cursor);
            return object2;
        }
        try {
            object = first;
        }
        catch (SQLException e) {
            try {
                throw SqlExceptionUtil.create((String)("queryForOne from database failed: " + statement), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(results);
                this.closeQuietly(cursor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)((Object)results));
        this.closeQuietly(cursor);
        return object;
    }

    public long queryForLong(String statement) throws java.sql.SQLException {
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            long result = stmt.simpleQueryForLong();
            logger.trace("{}: query for long simple query returned {}: {}", (Object)this, (Object)result, (Object)statement);
            long l = result;
            return l;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("queryForLong from database failed: " + statement), (Throwable)e);
        }
        finally {
            this.closeQuietly(stmt);
        }
    }

    public long queryForLong(String statement, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        long l;
        Cursor cursor = null;
        AndroidDatabaseResults results = null;
        try {
            cursor = this.db.rawQuery(statement, this.toStrings(args));
            results = new AndroidDatabaseResults(cursor, null, false);
            long result = results.first() ? results.getLong(0) : 0L;
            logger.trace("{}: query for long raw query returned {}: {}", (Object)this, (Object)result, (Object)statement);
            l = result;
            this.closeQuietly(cursor);
        }
        catch (SQLException e) {
            try {
                throw SqlExceptionUtil.create((String)("queryForLong from database failed: " + statement), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(cursor);
                IOUtils.closeQuietly(results);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)((Object)results));
        return l;
    }

    public void close() throws IOException {
        try {
            this.db.close();
            logger.trace("{}: db {} closed", (Object)this, (Object)this.db);
        }
        catch (SQLException e) {
            throw new IOException("problems closing the database connection", e);
        }
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((Closeable)((Object)this));
    }

    public boolean isClosed() throws java.sql.SQLException {
        try {
            boolean isOpen = this.db.isOpen();
            logger.trace("{}: db {} isOpen returned {}", (Object)this, (Object)this.db, (Object)isOpen);
            return !isOpen;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)"problems detecting if the database is closed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists(String tableName) {
        try (Cursor cursor = this.db.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = ?", new String[]{tableName});){
            boolean result = cursor.getCount() > 0;
            logger.trace("{}: isTableExists '{}' returned {}", (Object)this, (Object)tableName, (Object)result);
            boolean bl = result;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(String statement, Object[] args, FieldType[] argFieldTypes, String label) throws java.sql.SQLException {
        int result;
        SQLiteStatement stmt = null;
        try {
            stmt = this.db.compileStatement(statement);
            this.bindArgs(stmt, args, argFieldTypes);
            stmt.execute();
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create((String)("updating database failed: " + statement), (Throwable)e);
        }
        finally {
            this.closeQuietly(stmt);
            stmt = null;
        }
        try {
            stmt = this.db.compileStatement("SELECT CHANGES()");
            result = (int)stmt.simpleQueryForLong();
        }
        catch (SQLException e) {
            result = 1;
        }
        finally {
            this.closeQuietly(stmt);
        }
        logger.trace("{} statement is compiled and executed, changed {}: {}", (Object)label, (Object)result, (Object)statement);
        return result;
    }

    private void bindArgs(SQLiteStatement stmt, Object[] args, FieldType[] argFieldTypes) throws java.sql.SQLException {
        if (args == null) {
            return;
        }
        block7: for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                stmt.bindNull(i + 1);
                continue;
            }
            SqlType sqlType = argFieldTypes[i].getSqlType();
            switch (sqlType) {
                case STRING: 
                case LONG_STRING: 
                case CHAR: {
                    stmt.bindString(i + 1, arg.toString());
                    continue block7;
                }
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    stmt.bindLong(i + 1, ((Number)arg).longValue());
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    stmt.bindDouble(i + 1, ((Number)arg).doubleValue());
                    continue block7;
                }
                case BYTE_ARRAY: 
                case SERIALIZABLE: {
                    stmt.bindBlob(i + 1, (byte[])arg);
                    continue block7;
                }
                case DATE: 
                case BLOB: 
                case BIG_DECIMAL: {
                    throw new java.sql.SQLException("Invalid Android type: " + sqlType);
                }
                default: {
                    throw new java.sql.SQLException("Unknown sql argument type: " + sqlType);
                }
            }
        }
    }

    private String[] toStrings(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String[] strings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            strings[i] = arg == null ? null : arg.toString();
        }
        return strings;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    private void closeQuietly(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    private void closeQuietly(SQLiteStatement statement) {
        if (statement != null) {
            statement.close();
        }
    }

    static {
        VersionUtils.checkCoreVersusAndroidVersions((String)ANDROID_VERSION);
    }

    private static class OurSavePoint
    implements Savepoint {
        private String name;

        public OurSavePoint(String name) {
            this.name = name;
        }

        @Override
        public int getSavepointId() {
            return 0;
        }

        @Override
        public String getSavepointName() {
            return this.name;
        }
    }
}

