/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.cipher.android.apptools;

import android.content.AsyncTaskLoader;
import android.content.Context;
import com.j256.ormlite.dao.Dao;
import java.util.List;

public abstract class BaseOrmLiteLoader<T, ID>
extends AsyncTaskLoader<List<T>>
implements Dao.DaoObserver {
    protected Dao<T, ID> dao;
    private List<T> cachedResults;

    public BaseOrmLiteLoader(Context context) {
        super(context);
    }

    public BaseOrmLiteLoader(Context context, Dao<T, ID> dao) {
        super(context);
        this.dao = dao;
    }

    public void deliverResult(List<T> results) {
        if (!this.isReset() && this.isStarted()) {
            super.deliverResult(results);
        }
    }

    protected void onStartLoading() {
        if (this.cachedResults != null) {
            this.deliverResult(this.cachedResults);
        }
        if (this.takeContentChanged() || this.cachedResults == null) {
            this.forceLoad();
        }
        this.dao.registerObserver((Dao.DaoObserver)this);
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.cachedResults != null) {
            this.cachedResults.clear();
            this.cachedResults = null;
        }
        this.dao.unregisterObserver((Dao.DaoObserver)this);
    }

    public void onChange() {
        this.onContentChanged();
    }

    public void setDao(Dao<T, ID> dao) {
        this.dao = dao;
    }
}

